/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.external;

import com.e1c.langtool.common.Pair;
import java.time.Duration;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalApiAccessLimit {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalApiAccessLimit.class);
    private final long accessApiPeriod;
    private final int accessApiLimit;
    private final long symbolPeriod;
    private final int symbolLimit;
    private int totalSymbols;
    private final Lock lock = new ReentrantLock(true);
    private final Deque<Long> accessApiHistory = new ConcurrentLinkedDeque<Long>();
    private final Deque<Pair<Long, Integer>> symbolHistory = new ConcurrentLinkedDeque<Pair<Long, Integer>>();

    public ExternalApiAccessLimit(Duration accessApiPeriod, int accessApiLimit, Duration symbolPeriod, int symbolLimit) {
        this.accessApiPeriod = accessApiPeriod.toMillis();
        this.accessApiLimit = accessApiLimit;
        this.symbolPeriod = symbolPeriod.toMillis();
        this.symbolLimit = symbolLimit;
    }

    public synchronized void checkOrWaitAccessApiLimits() {
        block13: {
            if (this.accessApiLimit <= 0) {
                return;
            }
            if (this.accessApiHistory.size() >= this.accessApiLimit) {
                int total = 0;
                long lastAccessed = 0L;
                long checkTime = System.currentTimeMillis() - this.accessApiPeriod;
                Iterator<Long> iterator = this.accessApiHistory.iterator();
                while (iterator.hasNext()) {
                    Long access = iterator.next();
                    LOGGER.trace("API Accessed: " + String.valueOf(access));
                    if (access >= checkTime) {
                        ++total;
                    } else {
                        iterator.remove();
                        continue;
                    }
                    if (lastAccessed == 0L) {
                        lastAccessed = access;
                    }
                    if (total > this.accessApiLimit) continue;
                    lastAccessed = access;
                }
                if (total + 1 >= this.accessApiLimit) {
                    this.lock.lock();
                    try {
                        try {
                            long toWait = this.accessApiPeriod - (System.currentTimeMillis() - lastAccessed);
                            LOGGER.trace("Access API period: " + this.accessApiPeriod);
                            LOGGER.trace("Access API last access: " + lastAccessed);
                            LOGGER.trace("Access API wait: " + toWait);
                            if (toWait > 0L) {
                                Thread.sleep(toWait);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            this.lock.unlock();
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        this.lock.unlock();
                        throw throwable;
                    }
                    this.lock.unlock();
                }
            }
        }
        this.accessApiHistory.addFirst(System.currentTimeMillis());
        LOGGER.trace("Access API total: " + this.accessApiHistory.size());
    }

    public synchronized void checkOrWaitSymbolLimits(int textLength) {
        if (this.symbolLimit <= 0) {
            return;
        }
        if (this.totalSymbols + textLength >= this.symbolLimit) {
            int total;
            block13: {
                total = 0;
                long lastAccessed = 0L;
                long checkTime = System.currentTimeMillis() - this.symbolPeriod;
                Iterator<Pair<Long, Integer>> iterator = this.symbolHistory.iterator();
                while (iterator.hasNext()) {
                    Pair<Long, Integer> symbols = iterator.next();
                    LOGGER.trace("Symbol limit Accessed: " + String.valueOf(symbols.getKey()));
                    if (symbols.getKey() > checkTime) {
                        total += symbols.getValue().intValue();
                    } else {
                        iterator.remove();
                        continue;
                    }
                    if (lastAccessed == 0L) {
                        lastAccessed = symbols.getKey();
                    }
                    if (total + textLength > this.symbolLimit) continue;
                    lastAccessed = symbols.getKey();
                }
                if (total + textLength >= this.symbolLimit) {
                    this.lock.lock();
                    try {
                        try {
                            long toWait = this.symbolPeriod - (System.currentTimeMillis() - lastAccessed);
                            LOGGER.trace("Symbol limit period: " + this.symbolPeriod);
                            LOGGER.trace("Symbol limit last access: " + lastAccessed);
                            LOGGER.trace("Symbol limit wait: " + toWait);
                            if (toWait > 0L) {
                                Thread.sleep(toWait);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            this.lock.unlock();
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        this.lock.unlock();
                        throw throwable;
                    }
                    this.lock.unlock();
                }
            }
            this.totalSymbols = total;
        }
        this.symbolHistory.addFirst(new Pair<Long, Integer>(System.currentTimeMillis(), textLength));
        this.totalSymbols += textLength;
        LOGGER.trace("Symbol limit: " + this.totalSymbols);
    }
}

