/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.external;

import com.e1c.langtool.external.IExternalTranslationProvider;

public class ExternalTranslationProviderAttrs {
    private final String id;
    private final String name;
    private final int order;
    private final boolean cacheable;
    private final boolean textProcessable;
    private final IExternalTranslationProvider provider;

    private ExternalTranslationProviderAttrs(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.order = builder.order;
        this.cacheable = builder.cacheable;
        this.provider = builder.provider;
        this.textProcessable = builder.textProcessable;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public boolean isTextProcessable() {
        return this.textProcessable;
    }

    public IExternalTranslationProvider getProvider() {
        return this.provider;
    }

    public static class Builder {
        private final String id;
        private final String name;
        private int order = -1;
        private boolean cacheable = true;
        private boolean textProcessable = true;
        private final IExternalTranslationProvider provider;

        public Builder(String id, String name, IExternalTranslationProvider provider) {
            this.id = id;
            this.name = name;
            this.provider = provider;
        }

        public Builder order(int order) {
            if (order < 0) {
                order = -1;
            }
            this.order = order;
            return this;
        }

        public Builder cacheable(boolean cacheable) {
            this.cacheable = cacheable;
            return this;
        }

        public Builder textProcessable(boolean value) {
            this.textProcessable = value;
            return this;
        }

        public ExternalTranslationProviderAttrs build() {
            return new ExternalTranslationProviderAttrs(this);
        }
    }
}

