/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.external;

import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.external.Messages;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TranslitExternalTranslationProvider
implements IExternalTranslationProvider {
    private static final String LANGUAGE_CODE_EN = "en";
    private static final String LANGUAGE_CODE_RU = "ru";
    private static final Set<String> LANGUAGE_CODES = ImmutableSet.of((Object)"en", (Object)"ru");
    private static final Map<String, String> LANGUAGES = Map.of("en", Messages.TranslitExternalTranslationProvider_English, "ru", Messages.TranslitExternalTranslationProvider_Russian);
    private static final char[] CYRILLIC = new char[]{'\u0430', '\u0431', '\u0432', '\u0433', '\u0434', '\u0435', '\u0451', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043e', '\u043f', '\u0440', '\u0441', '\u0442', '\u0443', '\u0444', '\u0445', '\u0446', '\u0447', '\u0448', '\u0449', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f', '\u0410', '\u0411', '\u0412', '\u0413', '\u0414', '\u0415', '\u0401', '\u0416', '\u0417', '\u0418', '\u0419', '\u041a', '\u041b', '\u041c', '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042a', '\u042b', '\u042c', '\u042d', '\u042e', '\u042f'};
    private static final String[] LATIN = new String[]{"a", "b", "v", "g", "d", "e", "yo", "zh", "z", "i", "y", "k", "l", "m", "n", "o", "p", "r", "s", "t", "u", "f", "h", "ts", "ch", "sh", "sch", "y", "i", "ye", "e", "ju", "ja", "A", "B", "V", "G", "D", "E", "Yo", "Zh", "Z", "I", "Y", "K", "L", "M", "N", "O", "P", "R", "S", "T", "U", "F", "H", "Ts", "Ch", "Sh", "Sch", "Y", "I", "Ye", "E", "Ju", "Ja"};

    @Override
    public String getTranslationItemImageName() {
        return "icons/obj16/translit.png";
    }

    @Override
    public List<String> translate(String text, String sourceLocale, String targetLocale) {
        if (LANGUAGE_CODE_RU.equalsIgnoreCase(sourceLocale) && LANGUAGE_CODE_EN.equalsIgnoreCase(targetLocale)) {
            boolean isUpperCase = text.equals(text.toUpperCase());
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < text.length()) {
                boolean found = false;
                int x = 0;
                while (x < CYRILLIC.length) {
                    if (text.charAt(i) == CYRILLIC[x]) {
                        String latin = LATIN[x];
                        if (isUpperCase && latin.length() > 1) {
                            latin = latin.toUpperCase();
                        }
                        builder.append(latin);
                        found = true;
                        break;
                    }
                    ++x;
                }
                if (!found) {
                    builder.append(text.charAt(i));
                }
                ++i;
            }
            return Lists.newArrayList((Object[])new String[]{builder.toString()});
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, List<String>> translate(List<String> texts, String sourceLocale, String targetLocale) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        texts.forEach(text -> {
            List<String> list = res.put((String)text, this.translate((String)text, sourceLocale, targetLocale));
        });
        return res;
    }

    @Override
    public Set<String> getLanguageCodes() {
        return LANGUAGE_CODES;
    }

    @Override
    public Map<String, String> getLanguages(String targetLocale) {
        return LANGUAGES;
    }
}

