/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.external.cache;

import com.e1c.langtool.query.ISingleTranslationQuery;
import java.io.Serializable;

public final class TranslationQueryEntity
implements Serializable {
    private static final String DEFAULT_VALUE = "default";
    private static final long serialVersionUID = 4917751339504694294L;
    private final String providerId;
    private final String sourceLanguage;
    private final String targetLanguage;
    private final String text;

    public static TranslationQueryEntity fromQuery(ISingleTranslationQuery query, String providerId) {
        return new TranslationQueryEntity(providerId, query.getSourceLanguage(), query.getTargetLanguage(), query.getText());
    }

    public TranslationQueryEntity(String providerId, String sourceLanguage, String targetLanguage, String text) {
        this.providerId = providerId;
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.text = text;
    }

    private TranslationQueryEntity() {
        this.text = DEFAULT_VALUE;
        this.providerId = DEFAULT_VALUE;
        this.targetLanguage = "";
        this.sourceLanguage = "";
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    public String getText() {
        return this.text;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.providerId == null ? 0 : this.providerId.hashCode());
        result = 31 * result + (this.sourceLanguage == null ? 0 : this.sourceLanguage.hashCode());
        result = 31 * result + (this.targetLanguage == null ? 0 : this.targetLanguage.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TranslationQueryEntity other = (TranslationQueryEntity)obj;
        if (this.providerId == null ? other.providerId != null : !this.providerId.equals(other.providerId)) {
            return false;
        }
        if (this.sourceLanguage != other.sourceLanguage) {
            return false;
        }
        if (this.targetLanguage != other.targetLanguage) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

