/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.generatestring;

import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.collector.FeatureValueListSerializer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

public class TempFileFeatureCollection
implements Collection<FeatureValue> {
    private static final int CACHE_SIZE = 1000;
    private static final int ASYNC_WRITE_DELAY = 500;
    private static final Duration EXPIRE_DURATION = Duration.ofMinutes(5L);
    private final Cache<Long, Collection<FeatureValue>> cache = CacheBuilder.newBuilder().maximumSize(1000L).removalListener(this::cacheRemoved).expireAfterAccess(EXPIRE_DURATION).build();
    private DB dbIndex;
    private Map<String, Long> index;
    private AtomicLong lastTopId;
    private final AtomicInteger size = new AtomicInteger();
    private DB db;
    private Map<Long, Collection<FeatureValue>> map;
    private File indexFile;
    private File dbFile;

    public TempFileFeatureCollection() {
        this.initNewDb();
    }

    public synchronized void dispose() {
        if (this.dbIndex == null || this.db == null) {
            return;
        }
        this.dbIndex.close();
        this.db.close();
        this.map = null;
        this.index = null;
        this.lastTopId = null;
        this.dbIndex = null;
        this.db = null;
        this.cache.invalidateAll();
        if (this.indexFile.exists() || this.dbFile.exists()) {
            TranslationUtils.startCleanUpMapDbFiles(this.indexFile);
            TranslationUtils.startCleanUpMapDbFiles(this.dbFile);
        }
    }

    @Deprecated
    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() <= 0;
    }

    @Override
    public boolean contains(Object o) {
        FeatureValue fv;
        Long id;
        if (o instanceof FeatureValue && (id = this.getIndexId(fv = (FeatureValue)o)) != null) {
            Collection<FeatureValue> bucket = this.getResourceBucket(id);
            return bucket.contains(o);
        }
        return false;
    }

    public Iterator<Long> resourceIterator() {
        return this.index.values().iterator();
    }

    @Override
    public Iterator<FeatureValue> iterator() {
        final Iterator<Map.Entry<String, Long>> topIterator = this.index.entrySet().iterator();
        return new Iterator<FeatureValue>(){
            private final ReadWriteLock lock = new ReentrantReadWriteLock();
            private volatile Iterator<FeatureValue> featureIterator;

            @Override
            public boolean hasNext() {
                this.lock.readLock().lock();
                try {
                    if (this.featureIterator != null && this.featureIterator.hasNext()) {
                        boolean bl = this.featureIterator.hasNext();
                        return bl;
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
                this.lock.writeLock().lock();
                try {
                    if ((this.featureIterator == null || !this.featureIterator.hasNext()) && topIterator.hasNext()) {
                        this.featureIterator = this.getNextFeatureIterator();
                    }
                    boolean bl = this.featureIterator != null && this.featureIterator.hasNext();
                    return bl;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }

            @Override
            public FeatureValue next() {
                this.lock.readLock().lock();
                try {
                    if (this.featureIterator != null && this.featureIterator.hasNext()) {
                        FeatureValue featureValue = this.featureIterator.next();
                        return featureValue;
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
                this.lock.writeLock().lock();
                try {
                    if ((this.featureIterator == null || !this.featureIterator.hasNext()) && topIterator.hasNext()) {
                        this.featureIterator = this.getNextFeatureIterator();
                    }
                    if (this.featureIterator != null && this.featureIterator.hasNext()) {
                        FeatureValue featureValue = this.featureIterator.next();
                        return featureValue;
                    }
                    return null;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }

            private Iterator<FeatureValue> getNextFeatureIterator() {
                while (topIterator.hasNext()) {
                    Iterator<FeatureValue> iterator;
                    Map.Entry entry = (Map.Entry)topIterator.next();
                    long id = (Long)entry.getValue();
                    Collection<FeatureValue> bucket = TempFileFeatureCollection.this.getResourceBucket(id);
                    if (bucket == null || !(iterator = bucket.iterator()).hasNext()) continue;
                    return iterator;
                }
                return null;
            }
        };
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Cannot convert to Array");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Cannot convert to Array");
    }

    @Override
    public boolean add(FeatureValue e) {
        long id = this.getOrNewIndexId(e);
        boolean result = false;
        Collection<FeatureValue> bucket = this.getResourceBucket(id);
        try {
            result = bucket.add(e);
        }
        catch (UnsupportedOperationException e1) {
            ConcurrentHashMap.KeySetView newBucket = ConcurrentHashMap.newKeySet(bucket.size() + 1);
            newBucket.addAll(bucket);
            result = newBucket.add(e);
            this.cache.put((Object)id, newBucket);
        }
        if (result) {
            this.size.incrementAndGet();
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        FeatureValue fv;
        Long id;
        if (o instanceof FeatureValue && (id = this.getIndexId(fv = (FeatureValue)o)) != null) {
            boolean result;
            block4: {
                Collection<FeatureValue> bucket = this.getResourceBucket(id);
                result = false;
                try {
                    result = bucket.remove(o);
                }
                catch (UnsupportedOperationException e) {
                    if (!bucket.contains(o)) break block4;
                    ConcurrentHashMap.KeySetView newBucket = ConcurrentHashMap.newKeySet(bucket.size());
                    newBucket.addAll(bucket);
                    result = newBucket.remove(o);
                    this.cache.put((Object)id, newBucket);
                }
            }
            if (result) {
                this.size.decrementAndGet();
            }
            return result;
        }
        return false;
    }

    public void updateValue(FeatureValue value) {
        this.remove(value);
        this.add(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot check collection");
    }

    @Override
    public boolean addAll(Collection<? extends FeatureValue> c) {
        boolean result = false;
        for (FeatureValue featureValue : c) {
            result |= this.add(featureValue);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object object : c) {
            result |= this.remove(object);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot retain all");
    }

    @Override
    public void clear() {
        this.dispose();
        this.size.set(0);
        this.initNewDb();
    }

    private void initNewDb() {
        Serializer serializer = (Serializer)CorePlugin.getDefault().getInjector().getInstance(FeatureValueListSerializer.class);
        try {
            this.indexFile = File.createTempFile("LT-collecting-temp", "db");
            this.dbFile = File.createTempFile("LT-collecting-temp", "db");
        }
        catch (IOException e) {
            CorePlugin.logError(e);
        }
        this.dbIndex = DBMaker.newFileDB((File)this.indexFile).transactionDisable().mmapFileEnableIfSupported().closeOnJvmShutdown().deleteFilesAfterClose().cacheSize(1000).cacheWeakRefEnable().cacheLRUEnable().asyncWriteEnable().asyncWriteFlushDelay(500).snapshotEnable().make();
        this.index = this.dbIndex.createTreeMap("index").keySerializer(BTreeKeySerializer.STRING).valueSerializer(Serializer.LONG).counterEnable().makeOrGet();
        this.lastTopId = new AtomicLong();
        this.db = DBMaker.newFileDB((File)this.dbFile).mmapFileEnableIfSupported().transactionDisable().closeOnJvmShutdown().deleteFilesAfterClose().cacheDisable().asyncWriteEnable().asyncWriteFlushDelay(500).snapshotEnable().make();
        this.map = this.db.createTreeMap("features").keySerializer(BTreeKeySerializer.ZERO_OR_POSITIVE_LONG).valueSerializer(serializer).valuesOutsideNodesEnable().counterEnable().makeOrGet();
    }

    public Collection<FeatureValue> getResourceBucket(long id) {
        Collection bucket;
        try {
            bucket = (Collection)this.cache.get((Object)id, () -> {
                ConcurrentHashMap.KeySetView value = ConcurrentHashMap.newKeySet();
                Collection<FeatureValue> store = this.map.get(id);
                if (store != null) {
                    value.addAll(store);
                }
                return value;
            });
        }
        catch (ExecutionException e1) {
            bucket = ConcurrentHashMap.newKeySet();
            this.cache.put((Object)id, bucket);
        }
        return bucket;
    }

    public void putResourceBucket(long id, Collection<FeatureValue> bucket) {
        this.cache.put((Object)id, bucket);
    }

    private long getOrNewIndexId(FeatureValue fv) {
        return this.getOrNewIndexId(fv.getContextKey().getResourceId().toPortableString());
    }

    private long getOrNewIndexId(String resouceKey) {
        return this.index.computeIfAbsent(resouceKey, k -> this.newTopId());
    }

    private Long getIndexId(FeatureValue fv) {
        return this.index.get(fv.getContextKey().getResourceId().toPortableString());
    }

    private long newTopId() {
        return this.lastTopId.incrementAndGet();
    }

    private void cacheRemoved(RemovalNotification<Long, Collection<FeatureValue>> notification) {
        if (this.db != null && this.map != null) {
            if (((Collection)notification.getValue()).isEmpty()) {
                this.map.remove(notification.getKey());
            } else {
                this.map.put((Long)notification.getKey(), List.copyOf((Collection)notification.getValue()));
            }
        }
    }
}

