/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ignore;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.ignore.AbstractResourceIgnoreTranslationChecker;
import com.e1c.langtool.ignore.TransIgnoreFile;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ResourceIgnoreTranslationChecker
extends AbstractResourceIgnoreTranslationChecker {
    @Override
    public boolean ignoreTranslation(IProject project, TranslationSource source, IProgressMonitor monitor) {
        return this.internalIgnoreTranslation(project, source.getProjectRelativePath(), null, monitor);
    }

    @Override
    public boolean ignoreTranslation(IProject project, IPath resourceId, FeatureKey featureKey, IProgressMonitor monitor) {
        return this.internalIgnoreTranslation(project, resourceId, featureKey, monitor);
    }

    private boolean internalIgnoreTranslation(IProject project, IPath path, FeatureKey featureKey, IProgressMonitor monitor) {
        Map<IPath, Optional<TransIgnoreFile>> loadedCache = this.getProjectCache(project, monitor);
        int i = path.segmentCount() - 1;
        while (i > 0) {
            if (monitor.isCanceled()) break;
            IPath current = path.removeLastSegments(i);
            Optional loaded = loadedCache.computeIfAbsent(current, p -> {
                IFile file = project.getFile(current.append(".transignore"));
                if (file.exists()) {
                    return Optional.ofNullable(this.createAndLoad(file));
                }
                return Optional.empty();
            });
            if (loaded.isPresent()) {
                TransIgnoreFile file = (TransIgnoreFile)loaded.get();
                if (file.ignoreAllChildren(path)) {
                    return true;
                }
                if (featureKey != null && file.ignore(path, featureKey)) {
                    return true;
                }
            }
            --i;
        }
        return false;
    }
}

