/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ignore;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.ignore.TransIgnoreFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class TransIgnoreFileUtil {
    private TransIgnoreFileUtil() {
        throw new IllegalAccessError();
    }

    public static TransIgnoreFile createNew(IPath preffix) {
        return new TransIgnoreFile(preffix);
    }

    public static TransIgnoreFile createAndLoad(IFile file) throws CoreException, IOException {
        IPath preffix = file.getProjectRelativePath().removeLastSegments(1);
        return TransIgnoreFileUtil.createAndLoad(file, preffix);
    }

    public static TransIgnoreFile createAndLoad(IFile file, IPath preffix) throws CoreException, IOException {
        TransIgnoreFile ignore = TransIgnoreFileUtil.createNew(preffix);
        TransIgnoreFileUtil.load(ignore, file.getContents());
        return ignore;
    }

    public static void load(TransIgnoreFile ignore, IFile file) throws IOException, CoreException {
        TransIgnoreFileUtil.load(ignore, file.getContents());
    }

    public static void load(TransIgnoreFile ignore, InputStream input) throws IOException {
        String strLine;
        ignore.clear();
        BufferedReader br = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        while ((strLine = br.readLine()) != null) {
            TransIgnoreFile.Line line = null;
            line = !StringUtils.isBlank(strLine = strLine.trim()) && (strLine.startsWith("//") || strLine.startsWith("#")) ? new TransIgnoreFile.CommentLine(strLine) : (!StringUtils.isBlank(strLine) ? TransIgnoreFile.Rule.fromString(strLine) : new TransIgnoreFile.Line());
            ignore.addLine(line);
        }
    }

    public static void save(TransIgnoreFile ignore, IFile file, IProgressMonitor monitor) throws CoreException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));){
            Iterator<TransIgnoreFile.Line> iterator = ignore.getLines();
            while (iterator.hasNext()) {
                TransIgnoreFile.Line line = iterator.next();
                bw.write(line.getSring());
                bw.newLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ByteArrayInputStream source = new ByteArrayInputStream(os.toByteArray());
        if (file.exists()) {
            file.setContents((InputStream)source, true, true, monitor);
        } else {
            file.create((InputStream)source, true, monitor);
        }
    }
}

