/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.collector;

import com.e1c.langtool.collector.CacheChangeEvent;
import com.e1c.langtool.collector.CollectingServiceRegistry;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingCacheChangeListener;
import com.e1c.langtool.collector.ICollectingCacheManager;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.collector.ProjectCollectingCacheStore;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;

public final class CollectingCacheManager
implements ICollectingCacheManager {
    private final CollectingServiceRegistry collectingServiceRegistry;
    private final ListenerList<ICollectingCacheChangeListener> changeListeners = new ListenerList();
    private final IResourceChangeListener resourceChangeListener = this::resourceChanged;
    private final Map<IProject, ProjectCollectingCacheStore> projects = new ConcurrentHashMap<IProject, ProjectCollectingCacheStore>();
    private final Set<IProject> closedAndDisabled = ConcurrentHashMap.newKeySet();

    @Inject
    public CollectingCacheManager(CollectingServiceRegistry collectingServiceRegistry) {
        this.collectingServiceRegistry = collectingServiceRegistry;
    }

    public void activate() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 7);
    }

    public void deactivate() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.changeListeners.clear();
        Iterator<Map.Entry<IProject, ProjectCollectingCacheStore>> iterator = this.projects.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IProject, ProjectCollectingCacheStore> entry = iterator.next();
            entry.getValue().close();
            iterator.remove();
        }
        this.closedAndDisabled.clear();
    }

    @Override
    public void addChangeListener(ICollectingCacheChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    @Override
    public void removeChangeListener(ICollectingCacheChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    @Override
    public void clear(IProject project) {
        if (project == null) {
            return;
        }
        boolean needFireEvent = this.projects.containsKey(project);
        this.projects.computeIfPresent(project, (p, c) -> {
            this.internalDeleteCache((ProjectCollectingCacheStore)c);
            return null;
        });
        if (needFireEvent) {
            this.fireChanged(new CacheChangeEvent(project));
        }
        if (ProjectCollectingCacheStore.isCacheExist(project)) {
            ProjectCollectingCacheStore cache = new ProjectCollectingCacheStore(project, this.collectingServiceRegistry);
            this.internalDeleteCache(cache);
        }
    }

    @Override
    public void enableTrackChanges(IProject project) {
        if (project == null) {
            return;
        }
        this.closedAndDisabled.remove(project);
    }

    @Override
    public void closeAndDisableTrackChanges(IProject project) {
        if (project == null) {
            return;
        }
        this.closedAndDisabled.add(project);
        this.projects.computeIfPresent(project, (p, cache) -> {
            cache.close();
            System.gc();
            return null;
        });
    }

    private void internalDeleteCache(ProjectCollectingCacheStore cache) {
        if (cache != null) {
            try {
                cache.delete();
            }
            catch (Exception e) {
                CorePlugin.logError(e);
                try {
                    cache.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean invalidate(IProject project, IPath path) {
        if (project == null || path == null || path.isEmpty() || this.closedAndDisabled.contains(project)) {
            return false;
        }
        ProjectCollectingCacheStore cache = this.projects.get(project);
        if (cache == null && ProjectCollectingCacheStore.isCacheExist(project)) {
            cache = this.getOrCreateCache(project);
        }
        if (cache != null) {
            boolean result = cache.invalidate(path);
            this.fireChanged(new CacheChangeEvent(project, path));
            return result;
        }
        return false;
    }

    @Override
    public boolean isInvalidated(IProject project, IPath path) {
        if (project == null || path == null || path.isEmpty() || this.closedAndDisabled.contains(project)) {
            return false;
        }
        if (this.closedAndDisabled.contains(project)) {
            return true;
        }
        ProjectCollectingCacheStore cache = this.getOrCreateCache(project);
        return cache.isInvalidated(path);
    }

    @Override
    public boolean invalidateAll(IProject project) {
        if (project == null || this.closedAndDisabled.contains(project)) {
            return false;
        }
        ProjectCollectingCacheStore cache = this.projects.get(project);
        if (cache == null && ProjectCollectingCacheStore.isCacheExist(project)) {
            cache = this.getOrCreateCache(project);
        }
        if (cache != null) {
            boolean result = cache.invalidateAll();
            this.fireChanged(new CacheChangeEvent(project));
            return result;
        }
        return false;
    }

    @Override
    public Iterator<IPath> allInvalidated(IProject project) {
        if (project == null || this.closedAndDisabled.contains(project)) {
            return Collections.emptyIterator();
        }
        return this.getOrCreateCache(project).allInvalidated();
    }

    @Override
    public Iterator<IPath> allResources(IProject project) {
        if (project == null || this.closedAndDisabled.contains(project)) {
            return Collections.emptyIterator();
        }
        return this.getOrCreateCache(project).allResources();
    }

    @Override
    public Collection<FeatureValue> getInterface(IProject project, IPath path) {
        if (project == null || this.closedAndDisabled.contains(project)) {
            return null;
        }
        return this.getOrCreateCache(project).getInterface(path);
    }

    @Override
    public void putInterface(IProject project, IPath path, Collection<FeatureValue> values) {
        if (project == null || this.closedAndDisabled.contains(project)) {
            return;
        }
        this.getOrCreateCache(project).putInterface(path, values);
        this.fireChanged(new CacheChangeEvent(project, path));
    }

    @Override
    public Collection<FeatureValue> getModel(IProject project, IPath path) {
        if (project == null || this.closedAndDisabled.contains(project)) {
            return null;
        }
        return this.getOrCreateCache(project).getModel(path);
    }

    @Override
    public void putModel(IProject project, IPath path, Collection<FeatureValue> values) {
        if (project == null || this.closedAndDisabled.contains(project)) {
            return;
        }
        this.getOrCreateCache(project).putModel(path, values);
        this.fireChanged(new CacheChangeEvent(project, path));
    }

    @Override
    public Collection<FeatureValue> getModelComputed(IProject project, IPath path) {
        if (project == null || this.closedAndDisabled.contains(project)) {
            return null;
        }
        return this.getOrCreateCache(project).getModelComputed(path);
    }

    @Override
    public void putModelComputed(IProject project, IPath path, Collection<FeatureValue> values) {
        if (project == null || this.closedAndDisabled.contains(project)) {
            return;
        }
        this.getOrCreateCache(project).putModelComputed(path, values);
        this.fireChanged(new CacheChangeEvent(project, path));
    }

    private ProjectCollectingCacheStore getOrCreateCache(IProject project) {
        Assert.isNotNull((Object)project, (String)"Project cannot be null");
        return this.projects.computeIfAbsent(project, (? super K p) -> new ProjectCollectingCacheStore((IProject)p, this.collectingServiceRegistry));
    }

    private void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        IResource res = event.getResource();
        if (res instanceof IProject && (event.getType() == 2 || event.getType() == 4)) {
            this.clear((IProject)res);
            this.closedAndDisabled.remove(res);
        }
        if (event.getType() == 1 && (delta = event.getDelta()) != null && (delta.getKind() & 6) != 0) {
            try {
                delta.accept(resourceDelta -> {
                    if ((resourceDelta.getKind() & 4) != 0 && (resourceDelta.getFlags() & 0x40100) == 0) {
                        return true;
                    }
                    IResource resource = resourceDelta.getResource();
                    if (resource.getProject() != null && this.closedAndDisabled.contains(resource.getProject())) {
                        return false;
                    }
                    if (resource instanceof IFile) {
                        this.invalidate((IFile)resource);
                        return false;
                    }
                    return true;
                }, 6);
            }
            catch (CoreException e) {
                CorePlugin.logError(e);
            }
        }
    }

    private void fireChanged(CacheChangeEvent e) {
        for (ICollectingCacheChangeListener l : this.changeListeners) {
            try {
                SafeRunner.run(() -> l.cacheChanged(e));
            }
            catch (Throwable e1) {
                CorePlugin.logError(e1);
            }
        }
    }
}

