/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.collector;

import com.e1c.langtool.collector.CollectingFilterParticipant;
import com.e1c.langtool.collector.CollectingServiceRegistry;
import com.e1c.langtool.collector.FeatureCollectorFactory;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.collector.FeatureValueCollectingService;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.FeatureSettingsContributor;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

@Singleton
public class CollectingServiceRegistryImpl
implements CollectingServiceRegistry {
    private static final String ATT_CLASS = "class";
    private static final String ELEMENT_FACTORY = "collectorFactory";
    private static final String ELEMENT_FILTER = "filterParticipant";
    private static final String ELEMENT_CONTRIBUTOR = "featureSettingsContributor";
    private static final String ATT_ID = "id";
    private volatile Collection<FeatureCollectorFactory> factories;
    private volatile Map<String, CollectingFilterParticipant> filterParticipants;
    private volatile Collection<FeatureSettingsContributor> featureSettingsContributors;
    private volatile BiMap<String, FeatureSettings> featureSettingsIds;

    @Override
    public Collection<FeatureCollectorFactory> allFactories() {
        if (this.factories == null) {
            this.loadRegistry();
        }
        return this.factories;
    }

    @Override
    public Collection<CollectingFilterParticipant> allFilterParticipants() {
        if (this.filterParticipants == null) {
            this.loadRegistry();
        }
        return this.filterParticipants.values();
    }

    @Override
    public CollectingFilterParticipant getFilterParticipants(String id) {
        if (this.filterParticipants == null) {
            this.loadRegistry();
        }
        return this.filterParticipants.get(id);
    }

    @Override
    public Collection<FeatureSettingsContributor> allFeatureSettingsContributors() {
        if (this.featureSettingsContributors == null) {
            this.loadRegistry();
        }
        return this.featureSettingsContributors;
    }

    @Override
    public String getFeatureSettingsId(FeatureSettings settings) {
        if (this.featureSettingsIds == null) {
            this.loadAllFeatureSettings();
        }
        return (String)this.featureSettingsIds.inverse().getOrDefault((Object)settings, (Object)"");
    }

    @Override
    public FeatureSettings getFeatureSettings(String id) {
        if (this.featureSettingsIds == null) {
            this.loadAllFeatureSettings();
        }
        return (FeatureSettings)this.featureSettingsIds.get((Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRegistry() {
        Class<CollectingServiceRegistryImpl> clazz = CollectingServiceRegistryImpl.class;
        synchronized (CollectingServiceRegistryImpl.class) {
            IConfigurationElement[] configElements;
            if (this.factories != null && this.filterParticipants != null && this.featureSettingsContributors != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            LinkedList allFactories = Lists.newLinkedList();
            LinkedList allFeatureSettingsContributors = Lists.newLinkedList();
            HashMap allFilters = Maps.newHashMap();
            IConfigurationElement[] elements = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool", "collectingService");
            int length = configElements.length;
            int index = 0;
            while (index < length) {
                IConfigurationElement configElement = elements[index];
                if (configElement.getName().equals(ELEMENT_FACTORY)) {
                    try {
                        e = (FeatureCollectorFactory)configElement.createExecutableExtension(ATT_CLASS);
                        allFactories.add(e);
                    }
                    catch (CoreException e) {
                        CorePlugin.logError(e);
                    }
                } else if (configElement.getName().equals(ELEMENT_FILTER)) {
                    String id = configElement.getAttribute(ATT_ID);
                    if (allFilters.containsKey(id)) {
                        String message = MessageFormat.format("Collecting filter participant id duplication: {0} already exists with instance: {1}", id, allFilters.get(id));
                        CorePlugin.log(CorePlugin.createErrorStatus(message, null));
                    }
                    try {
                        CollectingFilterParticipant e = (CollectingFilterParticipant)configElement.createExecutableExtension(ATT_CLASS);
                        allFilters.put(id, e);
                    }
                    catch (CoreException e) {
                        CorePlugin.logError(e);
                    }
                } else if (configElement.getName().equals(ELEMENT_CONTRIBUTOR)) {
                    try {
                        e = (FeatureSettingsContributor)configElement.createExecutableExtension(ATT_CLASS);
                        allFeatureSettingsContributors.add(e);
                    }
                    catch (CoreException e) {
                        CorePlugin.logError(e);
                    }
                }
                ++index;
            }
            allFactories.addAll(FeatureValueCollectingService.loadDeprecatedFactories());
            this.factories = List.copyOf(allFactories);
            this.filterParticipants = Map.copyOf(allFilters);
            this.featureSettingsContributors = List.copyOf(allFeatureSettingsContributors);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllFeatureSettings() {
        CollectingServiceRegistryImpl collectingServiceRegistryImpl = this;
        synchronized (collectingServiceRegistryImpl) {
            if (this.featureSettingsIds != null) {
                return;
            }
            HashMap<Object, FeatureSettings> result = new HashMap<Object, FeatureSettings>();
            for (FeatureSettingsContributor contributor : this.allFeatureSettingsContributors()) {
                Class<?> clazz = contributor.getClass();
                List<FeatureSettings> allSettings = contributor.getFeatureSettings();
                if (allSettings.isEmpty()) continue;
                Map<FeatureSettings, String> featureSettingsNames = this.getFeaturesFromClass(clazz);
                String className = clazz.getName();
                int i = 0;
                for (FeatureSettings settings : allSettings) {
                    Object id = featureSettingsNames.get(settings);
                    if (id == null) {
                        id = className + "::" + settings.getName() + ":" + ++i;
                    }
                    if (result.containsKey(id) || result.containsValue(settings)) continue;
                    result.put(id, settings);
                }
            }
            this.featureSettingsIds = ImmutableBiMap.copyOf(result);
        }
    }

    private Map<FeatureSettings, String> getFeaturesFromClass(Class<?> clazz) {
        Class<?>[] classArray;
        Map<FeatureSettings, String> featureSettingsNames = new HashMap<FeatureSettings, String>();
        String className = clazz.getName();
        Field[] fileds = clazz.getDeclaredFields();
        int j = 0;
        while (j < fileds.length) {
            Field field = fileds[j];
            try {
                Object value = field.get(null);
                if (value instanceof FeatureSettings) {
                    String id = className + "::" + field.getName();
                    featureSettingsNames.put((FeatureSettings)value, id);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            ++j;
        }
        if (featureSettingsNames.isEmpty()) {
            classArray = clazz.getNestMembers();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> subClazz = classArray[n2];
                if (subClazz != clazz && !(featureSettingsNames = this.getFeaturesFromClass(subClazz)).isEmpty()) break;
                ++n2;
            }
        }
        if (featureSettingsNames.isEmpty()) {
            classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n3 = 0;
            while (n3 < n) {
                Class<?> subClazz = classArray[n3];
                if (subClazz != clazz && !(featureSettingsNames = this.getFeaturesFromClass(subClazz)).isEmpty()) break;
                ++n3;
            }
        }
        return featureSettingsNames;
    }
}

