/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.collector;

import com.e1c.langtool.internal.collector.FeatureValueCacheEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.mapdb.Serializer;

public class FeatureValueCacheEntryListSerializer
implements Serializer<Collection<FeatureValueCacheEntry>>,
Serializable {
    private static final long serialVersionUID = 2418158069193478587L;

    public void serialize(DataOutput out, Collection<FeatureValueCacheEntry> values) throws IOException {
        out.writeInt(values.size());
        for (FeatureValueCacheEntry value : values) {
            out.writeInt(value.getFeatureSettingsId());
            out.writeInt(value.getFeatureKey().length);
            int i = 0;
            while (i < value.getFeatureKey().length) {
                out.writeUTF(value.getFeatureKey()[i]);
                ++i;
            }
            out.writeUTF(value.getValue());
            out.writeUTF(value.getComment());
            out.writeUTF(value.getResourceId());
            out.writeBoolean(value.isUnknown());
            out.writeBoolean(value.isTag());
        }
    }

    public Collection<FeatureValueCacheEntry> deserialize(DataInput in, int available) throws IOException {
        int total = in.readInt();
        FeatureValueCacheEntry[] content = new FeatureValueCacheEntry[total];
        int i = 0;
        while (i < total) {
            int featureSettingsId = in.readInt();
            String[] featureKey = new String[in.readInt()];
            int j = 0;
            while (j < featureKey.length) {
                featureKey[j] = in.readUTF();
                ++j;
            }
            String value = in.readUTF();
            String comment = in.readUTF();
            String resourceId = in.readUTF();
            boolean isUnknown = in.readBoolean();
            boolean isTag = in.readBoolean();
            content[i] = new FeatureValueCacheEntry(featureKey, featureSettingsId, value, comment, resourceId, isUnknown, isTag);
            ++i;
        }
        return List.of(content);
    }

    public int fixedSize() {
        return -1;
    }
}

