/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.collector;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.CollectingException;
import com.e1c.langtool.collector.CollectingFilterParticipant;
import com.e1c.langtool.collector.CollectingServiceRegistry;
import com.e1c.langtool.collector.FeatureCollectorFactory;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingCacheManager;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.ignore.IgnoreTranslationCheckingService;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.collector.Messages;
import com.e1c.langtool.platform.TranslateLanguage;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;

public class FeatureValueCollectingService
implements IFeatureValueCollectingService {
    private static final String EXTENSION_POINT_ID = "com.e1c.langtool.featureCollectorFactories";
    private static final String ATT_CLASS = "class";
    @Inject
    private CollectingServiceRegistry registry;
    @Inject
    private ICollectingCacheManager cacheManager;
    @Inject
    private IgnoreTranslationCheckingService ignoreService;

    @Override
    public boolean hasCollector(Object source) {
        Object obj = source instanceof TranslationSource ? ((TranslationSource)source).getSourceObject() : source;
        for (FeatureCollectorFactory featureCollectorFactory : this.registry.allFactories()) {
            if (!featureCollectorFactory.isSupport(obj)) continue;
            return true;
        }
        return false;
    }

    public Set<FeatureValueCollector> createCollectors(TranslationSource source, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        return this.createCollectors(source, parameters, addAction, (IProgressMonitor)new NullProgressMonitor());
    }

    public Set<FeatureValueCollector> createCollectors(TranslationSource source, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction, IProgressMonitor monitor) {
        LinkedHashSet allCollectors = Sets.newLinkedHashSet();
        if (monitor.isCanceled() || source.getProject() == null || this.ignoreService.ignoreTranslation(source.getProject(), source, monitor)) {
            return allCollectors;
        }
        for (CollectingFilterParticipant filter : this.registry.allFilterParticipants()) {
            if (!monitor.isCanceled() && filter.canCollect(source, parameters.getFilterParameters(), monitor)) continue;
            return allCollectors;
        }
        for (FeatureCollectorFactory featureCollectorFactory : this.registry.allFactories()) {
            if (!featureCollectorFactory.isSupport(source.getSourceObject())) continue;
            if (monitor.isCanceled()) {
                return allCollectors;
            }
            Set<FeatureValueCollector> collectors = featureCollectorFactory.createCollectors(source.getSourceObject(), parameters, addAction);
            if (collectors == null || collectors.isEmpty()) continue;
            allCollectors.addAll(collectors);
        }
        return allCollectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<FeatureCollectorFactory> loadDeprecatedFactories() {
        Class<FeatureValueCollectingService> clazz = FeatureValueCollectingService.class;
        synchronized (FeatureValueCollectingService.class) {
            IConfigurationElement[] configElements;
            LinkedList allFactories = Lists.newLinkedList();
            IConfigurationElement[] elements = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
            int length = configElements.length;
            int index = 0;
            while (index < length) {
                IConfigurationElement configElement = elements[index];
                try {
                    FeatureCollectorFactory e = (FeatureCollectorFactory)configElement.createExecutableExtension(ATT_CLASS);
                    allFactories.add(e);
                }
                catch (CoreException e) {
                    CorePlugin.logError(e);
                }
                ++index;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return allFactories;
        }
    }

    @Override
    public void collectAll(IProject project, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> action, ExecutorService executorService, final IProgressMonitor monitor) {
        if (!parameters.isCollectChildObjects() || !parameters.isCollectSubResources()) {
            return;
        }
        boolean disableCache = !parameters.useCache();
        for (CollectingFilterParticipant filter : this.registry.allFilterParticipants()) {
            disableCache |= !filter.canUseCollectingCache(parameters.getFilterParameters());
        }
        FileCollectingParameters fileParameters = new FileCollectingParameters(parameters, !disableCache, false);
        FileCollectingParameters cacheParameters = new FileCollectingParameters(parameters, !disableCache, true);
        NullProgressMonitor subMonitor = new NullProgressMonitor(){

            public boolean isCanceled() {
                return monitor.isCanceled();
            }
        };
        try {
            project.accept(arg_0 -> this.lambda$0(monitor, executorService, fileParameters, cacheParameters, action, (IProgressMonitor)subMonitor, arg_0));
        }
        catch (CoreException e) {
            CorePlugin.logError(e);
        }
    }

    @Override
    public void collectAllByFile(IProject project, ICollectingParameters parameters, BiConsumer<IFile, Collection<FeatureValue>> action, ExecutorService executorService, final IProgressMonitor monitor) {
        if (!parameters.isCollectChildObjects() || !parameters.isCollectSubResources()) {
            return;
        }
        boolean disableCache = !parameters.useCache();
        for (CollectingFilterParticipant filter : this.registry.allFilterParticipants()) {
            disableCache |= !filter.canUseCollectingCache(parameters.getFilterParameters());
        }
        FileCollectingParameters fileParameters = new FileCollectingParameters(parameters, !disableCache, false);
        FileCollectingParameters cacheParameters = new FileCollectingParameters(parameters, !disableCache, true);
        NullProgressMonitor subMonitor = new NullProgressMonitor(){

            public boolean isCanceled() {
                return monitor.isCanceled();
            }
        };
        try {
            project.accept(arg_0 -> this.lambda$2(fileParameters, cacheParameters, (IProgressMonitor)subMonitor, action, monitor, executorService, arg_0));
        }
        catch (CoreException e) {
            CorePlugin.logError(e);
        }
    }

    @Override
    public void collectFile(IFile file, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> action, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        boolean disableCache = !parameters.useCache();
        for (CollectingFilterParticipant filter : this.registry.allFilterParticipants()) {
            disableCache |= !filter.canUseCollectingCache(parameters.getFilterParameters());
        }
        FileCollectingParameters cacheParameters = new FileCollectingParameters(parameters, !disableCache, true);
        this.collectFileInternal(file, parameters, cacheParameters, action, monitor);
    }

    @Override
    public void forEachCollected(TranslationSource source, ICollectingParameters parameters, IProgressMonitor monitor, BiConsumer<Object, FeatureValue> action) {
        if (monitor.isCanceled()) {
            return;
        }
        Set<FeatureValueCollector> allCollectors = this.createCollectors(source, parameters, (sourceObject, value) -> {
            for (CollectingFilterParticipant filter : this.registry.allFilterParticipants()) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (filter.needCollectRaw(source, sourceObject, (FeatureValue)value, parameters.getFilterParameters(), monitor)) continue;
                return;
            }
            action.accept(sourceObject, (FeatureValue)value);
        }, monitor);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.FeatureValueCollectingService_Collecting_translating_features, (int)allCollectors.size());
        Iterator<FeatureValueCollector> iterator = allCollectors.iterator();
        while (iterator.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            FeatureValueCollector collector = iterator.next();
            if (collector == null) continue;
            try {
                collector.process((IProgressMonitor)subMonitor.newChild(1));
            }
            catch (CollectingException e) {
                if (parameters.isContinueAfterFirstError()) {
                    parameters.getErrors().add(e);
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                CollectingException e2 = new CollectingException(source, (Throwable)e, true, true);
                CorePlugin.logError(e2);
                if (parameters.isContinueAfterFirstError()) {
                    parameters.getErrors().add(e2);
                    continue;
                }
                throw e2;
            }
        }
        subMonitor.done();
    }

    private void collectFileInternal(IFile file, ICollectingParameters parameters, ICollectingParameters cacheParameters, BiConsumer<Object, FeatureValue> action, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        TranslationSource source = TranslationUtils.getTranslationSource(file);
        if (source == null || this.ignoreService.ignoreTranslation(file.getProject(), source, monitor)) {
            return;
        }
        if (parameters.useCache()) {
            this.collectFileWithCache(file, source, parameters, cacheParameters, action, monitor);
        } else {
            try {
                this.forEachCollected(source, parameters, monitor, action);
            }
            catch (Exception e) {
                CorePlugin.logError(e);
            }
        }
    }

    private void collectFileWithCache(IFile file, TranslationSource source, ICollectingParameters parameters, ICollectingParameters cacheParameters, BiConsumer<Object, FeatureValue> action, IProgressMonitor monitor) {
        for (CollectingFilterParticipant filter : this.registry.allFilterParticipants()) {
            if (!monitor.isCanceled() && filter.canCollect(source, parameters.getFilterParameters(), monitor)) continue;
            return;
        }
        if (parameters.isCollectInterfaceStrings() && !parameters.isCollectModelStrings()) {
            this.collectFileWithCacheInterfaceOnly(file, source, parameters, cacheParameters, action, monitor);
        } else {
            this.collectFileWithCacheAllTypes(file, source, parameters, cacheParameters, action, monitor);
        }
    }

    private void collectFileWithCacheInterfaceOnly(IFile file, TranslationSource source, ICollectingParameters parameters, ICollectingParameters cacheParameters, BiConsumer<Object, FeatureValue> action, IProgressMonitor monitor) {
        Consumer<FeatureValue> filteringAction = value -> {
            for (CollectingFilterParticipant filter : this.registry.allFilterParticipants()) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (filter.needCollect(source, (FeatureValue)value, parameters.getFilterParameters(), monitor)) continue;
                return;
            }
            action.accept(source.getSourceObject(), (FeatureValue)value);
        };
        Collection<FeatureValue> cache = this.cacheManager.computeIfAbsentInterface(file, f -> {
            ArrayList result = new ArrayList();
            try {
                this.forEachCollected(source, cacheParameters, monitor, (sourcObject, value) -> {
                    if (!this.ignoreService.ignoreTranslation(file.getProject(), (ContextTranslationKey)value, monitor)) {
                        result.add(value);
                    }
                });
            }
            catch (Exception e) {
                CorePlugin.logError(e);
                return null;
            }
            if (monitor.isCanceled()) {
                return null;
            }
            return result;
        });
        if (!monitor.isCanceled() && cache != null) {
            cache.forEach(filteringAction);
        }
    }

    private void collectFileWithCacheAllTypes(IFile file, TranslationSource source, ICollectingParameters parameters, ICollectingParameters cacheParameters, BiConsumer<Object, FeatureValue> action, IProgressMonitor monitor) {
        Consumer<FeatureValue> filteringAction = value -> {
            boolean isInterface = value.getContextKey().getFeatureSettings().isInterface();
            if (this.notCollectInterfaceOrNotValidModelValue(parameters, (FeatureValue)value, isInterface)) {
                return;
            }
            for (CollectingFilterParticipant filter : this.registry.allFilterParticipants()) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (filter.needCollect(source, (FeatureValue)value, parameters.getFilterParameters(), monitor)) continue;
                return;
            }
            action.accept(source.getSourceObject(), (FeatureValue)value);
        };
        Collection<FeatureValue> cache = this.cacheManager.computeIfAbsent(file, f -> {
            ArrayList result = new ArrayList();
            try {
                this.forEachCollected(source, cacheParameters, monitor, (sourcObject, value) -> {
                    if (!this.ignoreService.ignoreTranslation(file.getProject(), (ContextTranslationKey)value, monitor)) {
                        result.add(value);
                    }
                });
            }
            catch (Exception e) {
                CorePlugin.logError(e);
                return null;
            }
            if (monitor.isCanceled()) {
                return null;
            }
            return result;
        });
        if (!monitor.isCanceled() && cache != null) {
            cache.forEach(filteringAction);
        }
    }

    private boolean notCollectInterfaceOrNotValidModelValue(ICollectingParameters parameters, FeatureValue value, boolean isInterface) {
        return !parameters.isCollectInterfaceStrings() && isInterface || !isInterface && !TranslationUtils.isValidValueForCollectModelType(value.isComputedValue(), value.isUnknown(), value.isTag(), parameters.getCollectModelType());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$0(IProgressMonitor iProgressMonitor, ExecutorService executorService, ICollectingParameters iCollectingParameters, ICollectingParameters iCollectingParameters2, BiConsumer biConsumer, IProgressMonitor iProgressMonitor2, IResource r) throws CoreException {
        if (iProgressMonitor.isCanceled()) {
            return false;
        }
        IResource iResource = r;
        if (iResource instanceof IFile) {
            void file;
            IFile iFile = (IFile)iResource;
            IFile cfr_ignored_0 = (IFile)iResource;
            executorService.submit(() -> this.lambda$1((IFile)file, iCollectingParameters, iCollectingParameters2, biConsumer, iProgressMonitor2));
            return true;
        }
        return true;
    }

    private /* synthetic */ boolean lambda$2(ICollectingParameters iCollectingParameters, ICollectingParameters iCollectingParameters2, IProgressMonitor iProgressMonitor, BiConsumer biConsumer, IProgressMonitor iProgressMonitor2, ExecutorService executorService, IResource r) throws CoreException {
        if (iProgressMonitor2.isCanceled()) {
            return false;
        }
        if (r instanceof IFile) {
            executorService.submit(() -> {
                ArrayList result = new ArrayList();
                BiConsumer<Object, FeatureValue> fileAction = (object, fv) -> {
                    boolean bl = result.add(fv);
                };
                this.collectFileInternal((IFile)r, iCollectingParameters, iCollectingParameters2, fileAction, iProgressMonitor);
                biConsumer.accept((IFile)r, result);
            });
            return true;
        }
        return true;
    }

    private /* synthetic */ void lambda$1(IFile iFile, ICollectingParameters iCollectingParameters, ICollectingParameters iCollectingParameters2, BiConsumer biConsumer, IProgressMonitor iProgressMonitor) {
        this.collectFileInternal(iFile, iCollectingParameters, iCollectingParameters2, biConsumer, iProgressMonitor);
    }

    private final class FileCollectingParameters
    implements ICollectingParameters {
        private final ICollectingParameters root;
        private final boolean useCache;
        private final boolean forCache;

        public FileCollectingParameters(ICollectingParameters root, boolean useCache, boolean forCache) {
            this.root = root;
            this.useCache = useCache;
            this.forCache = forCache;
        }

        @Override
        public boolean isCollectChildObjects() {
            return this.root.isCollectChildObjects();
        }

        @Override
        public boolean isCollectModelStrings() {
            return this.root.isCollectModelStrings();
        }

        @Override
        public boolean isCollectInterfaceStrings() {
            if (this.forCache && this.isCollectModelStrings()) {
                return true;
            }
            return this.root.isCollectInterfaceStrings();
        }

        @Override
        public ICollectingParameters.CollectModelType getCollectModelType() {
            if (this.forCache && this.isCollectModelStrings()) {
                return ICollectingParameters.CollectModelType.ANY;
            }
            return this.root.getCollectModelType();
        }

        @Override
        public boolean isCollectSubResources() {
            if (!this.forCache) {
                return this.root.isCollectChildObjects();
            }
            return false;
        }

        @Override
        public Set<TranslateLanguage> getLanguages() {
            return this.root.getLanguages();
        }

        @Override
        public boolean isCollectEmptyValue() {
            return this.root.isCollectEmptyValue();
        }

        @Override
        public boolean isContinueAfterFirstError() {
            return this.root.isContinueAfterFirstError();
        }

        @Override
        public Collection<Exception> getErrors() {
            return this.root.getErrors();
        }

        @Override
        public Map<String, Object> getFilterParameters() {
            if (this.forCache) {
                return Collections.emptyMap();
            }
            return this.root.getFilterParameters();
        }

        @Override
        public boolean useCache() {
            return this.useCache;
        }

        @Override
        public boolean isKeepLanguagesMode() {
            return this.root.isKeepLanguagesMode();
        }
    }
}

