/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.collector;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.generatestring.FeatureValueSerializer;
import com.e1c.langtool.internal.CorePlugin;
import com.google.inject.Inject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.mapdb.Serializer;

public class FeatureValueListSerializer
implements Serializer<Collection<FeatureValue>>,
Serializable {
    private static final long serialVersionUID = 7906333027108553870L;
    private transient FeatureValueSerializer featureValueSerializer;

    @Inject
    public FeatureValueListSerializer(FeatureValueSerializer featureValueSerializer) {
        this.featureValueSerializer = featureValueSerializer;
    }

    public FeatureValueListSerializer() {
        this.featureValueSerializer = (FeatureValueSerializer)CorePlugin.getDefault().getInjector().getInstance(FeatureValueSerializer.class);
    }

    public void serialize(DataOutput out, Collection<FeatureValue> values) throws IOException {
        int size = values.size();
        out.writeInt(size);
        int total = 0;
        for (FeatureValue key : values) {
            this.getFeatureValueSerializer().serialize(out, key);
            ++total;
        }
        Assert.isLegal((size == total ? 1 : 0) != 0, (String)"Collection of Feature values changed while serializing");
    }

    public Collection<FeatureValue> deserialize(DataInput in, int available) throws IOException {
        int total = in.readInt();
        FeatureValue[] content = new FeatureValue[total];
        int i = 0;
        while (i < total) {
            content[i] = this.getFeatureValueSerializer().deserialize(in, available);
            ++i;
        }
        return List.of(content);
    }

    public int fixedSize() {
        return -1;
    }

    private FeatureValueSerializer getFeatureValueSerializer() {
        if (this.featureValueSerializer == null) {
            this.featureValueSerializer = (FeatureValueSerializer)CorePlugin.getDefault().getInjector().getInstance(FeatureValueSerializer.class);
        }
        return this.featureValueSerializer;
    }
}

