/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.collector;

import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.CollectingServiceRegistry;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.PathSerializer;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.collector.FeatureValueCacheEntry;
import com.e1c.langtool.internal.collector.FeatureValueCacheEntryListSerializer;
import com.e1c.langtool.settings.FeatureSettings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.osgi.framework.Bundle;

public class ProjectCollectingCacheStore {
    private static final String VERSION_KEY = "version";
    private static final int STORAGE_VERSION = 1;
    private static final int ASYNC_WRITE_DELAY = 500;
    private static final int CACHE_SIZE = 100;
    private static final String DB_FOLDER = "cache";
    private static final String DB_FILE_NAME_INDEX = "index.db";
    private static final String DB_FILE_NAME_INTERFACE = "interface.db";
    private static final String DB_FILE_NAME_MODEL = "model.db";
    private static final String DB_FILE_NAME_MODEL_COMPUTED = "modelComputed.db";
    private static final Duration EXPIRE_DURATION = Duration.ofMinutes(5L);
    private final IProject project;
    private final Cache<IPath, Collection<FeatureValue>> interfaceCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(EXPIRE_DURATION).build();
    private final Cache<IPath, Collection<FeatureValue>> modelCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(EXPIRE_DURATION).build();
    private final Cache<IPath, Collection<FeatureValue>> modelComputedCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(EXPIRE_DURATION).build();
    private final Map<Integer, String> featureSettingsIdsBackMap = new ConcurrentHashMap<Integer, String>();
    private final CollectingServiceRegistry collectingServiceRegistry;
    private final ReadWriteLock initializationLock = new ReentrantReadWriteLock(false);
    private volatile boolean initialized;
    private volatile boolean inMemory;
    private DB dbIndex;
    private DB dbInterface;
    private DB dbModel;
    private DB dbModelComputed;
    private Atomic.Long lastId;
    private AtomicLong inMemoryLastId;
    private Map<IPath, Long> resources;
    private Map<String, Integer> featureSettingsIds;
    private Atomic.Integer lastFeauteId;
    private Set<Long> invalidated;
    private Map<Long, Collection<FeatureValueCacheEntry>> interfaceValues;
    private Map<Long, Collection<FeatureValueCacheEntry>> model;
    private Map<Long, Collection<FeatureValueCacheEntry>> modelComputed;

    public static boolean isCacheExist(IProject project) {
        File file = ProjectCollectingCacheStore.getStorageFileIndex(project);
        return file.exists();
    }

    public ProjectCollectingCacheStore(IProject project, CollectingServiceRegistry collectingServiceRegistry) {
        Assert.isNotNull((Object)project);
        this.project = project;
        this.collectingServiceRegistry = collectingServiceRegistry;
    }

    public void open() {
        if (this.initialized) {
            return;
        }
        this.initializationLock.writeLock().lock();
        this.inMemory = false;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ProjectCollectingCacheStore.class.getClassLoader());
            this.internalOpen();
            this.initialized = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
            this.initializationLock.writeLock().unlock();
        }
    }

    public void close() {
        this.initializationLock.writeLock().lock();
        try {
            this.resources = null;
            this.invalidated = null;
            this.interfaceValues = null;
            this.model = null;
            this.modelComputed = null;
            this.lastId = null;
            this.lastFeauteId = null;
            this.featureSettingsIds = null;
            if (this.dbIndex != null && !this.dbIndex.isClosed()) {
                this.dbIndex.close();
            }
            this.dbIndex = null;
            if (this.dbInterface != null && !this.dbInterface.isClosed()) {
                this.dbInterface.close();
            }
            this.dbInterface = null;
            if (this.dbModel != null && !this.dbModel.isClosed()) {
                this.dbModel.close();
            }
            this.dbModel = null;
            if (this.dbModelComputed != null && !this.dbModelComputed.isClosed()) {
                this.dbModelComputed.close();
            }
            this.dbModelComputed = null;
            this.initialized = false;
        }
        finally {
            this.initializationLock.writeLock().unlock();
        }
    }

    public void delete() {
        this.initializationLock.writeLock().lock();
        try {
            this.close();
            TranslationUtils.cleanUpMabDbFiles(ProjectCollectingCacheStore.getStorageFileIndex(this.project));
            TranslationUtils.cleanUpMabDbFiles(ProjectCollectingCacheStore.getStorageFileInterface(this.project));
            TranslationUtils.cleanUpMabDbFiles(ProjectCollectingCacheStore.getStorageFileModel(this.project));
            TranslationUtils.cleanUpMabDbFiles(ProjectCollectingCacheStore.getStorageFileModelComputed(this.project));
        }
        finally {
            this.initializationLock.writeLock().unlock();
        }
    }

    public boolean invalidate(IPath path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        this.checkOrOpen();
        this.initializationLock.readLock().lock();
        try {
            Long id = this.resources.get(path);
            this.interfaceCache.invalidate((Object)path);
            this.modelCache.invalidate((Object)path);
            this.modelComputedCache.invalidate((Object)path);
            boolean bl = id != null && this.invalidated.add(id);
            return bl;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    public boolean isInvalidated(IPath path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        this.checkOrOpen();
        this.initializationLock.readLock().lock();
        try {
            Long id = this.resources.get(path);
            boolean bl = id == null || this.invalidated.contains(id);
            return bl;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    public boolean invalidateAll() {
        this.checkOrOpen();
        this.initializationLock.readLock().lock();
        try {
            this.interfaceCache.invalidateAll();
            this.modelCache.invalidateAll();
            this.modelComputedCache.invalidateAll();
            boolean bl = this.invalidated.addAll(this.resources.values());
            return bl;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    public Iterator<IPath> allInvalidated() {
        this.checkOrOpen();
        this.initializationLock.readLock().lock();
        try {
            Iterator<IPath> iterator = this.resources.entrySet().stream().filter(e -> this.invalidated.contains(e.getValue())).map(Map.Entry::getKey).iterator();
            return iterator;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    public Iterator<IPath> allResources() {
        this.checkOrOpen();
        this.initializationLock.readLock().lock();
        try {
            Iterator<IPath> iterator = this.resources.keySet().iterator();
            return iterator;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    public boolean remove(IPath path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        this.checkOrOpen();
        this.initializationLock.readLock().lock();
        try {
            Long id = this.resources.get(path);
            if (id != null) {
                this.invalidated.remove(id);
                this.interfaceCache.invalidate((Object)path);
                this.modelCache.invalidate((Object)path);
                this.modelComputedCache.invalidate((Object)path);
                this.interfaceValues.remove(id);
                this.model.remove(id);
                this.modelComputed.remove(id);
                this.resources.remove(path);
                return true;
            }
            return false;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    public Collection<FeatureValue> getInterface(IPath path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        this.checkOrOpen();
        this.initializationLock.readLock().lock();
        try {
            Long id = this.resources.get(path);
            if (id == null) {
                return null;
            }
            Collection collection = (Collection)this.interfaceCache.get((Object)path, () -> {
                Collection<FeatureValueCacheEntry> values = this.interfaceValues.get(id);
                if (values != null) {
                    return values.stream().map(v -> this.createFeatureValue(path, (FeatureValueCacheEntry)v, false)).collect(Collectors.toList());
                }
                throw new IllegalAccessException("Empty value");
            });
            return collection;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    public Collection<FeatureValue> getModel(IPath path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        this.checkOrOpen();
        this.initializationLock.readLock().lock();
        try {
            Long id = this.resources.get(path);
            if (id == null) {
                return null;
            }
            Collection collection = (Collection)this.modelCache.get((Object)path, () -> {
                Collection<FeatureValueCacheEntry> values = this.model.get(id);
                if (values != null) {
                    return values.stream().map(v -> this.createFeatureValue(path, (FeatureValueCacheEntry)v, false)).collect(Collectors.toList());
                }
                throw new IllegalAccessException("Empty value");
            });
            return collection;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    public Collection<FeatureValue> getModelComputed(IPath path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        this.checkOrOpen();
        this.initializationLock.readLock().lock();
        try {
            Long id = this.resources.get(path);
            if (id == null) {
                return null;
            }
            Collection collection = (Collection)this.modelComputedCache.get((Object)path, () -> {
                Collection<FeatureValueCacheEntry> values = this.modelComputed.get(id);
                if (values != null) {
                    return values.stream().map(v -> this.createFeatureValue(path, (FeatureValueCacheEntry)v, true)).collect(Collectors.toList());
                }
                throw new IllegalAccessException("Empty value");
            });
            return collection;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    public void putInterface(IPath path, Collection<FeatureValue> values) {
        if (path == null || path.isEmpty()) {
            return;
        }
        this.checkOrOpen();
        this.initializationLock.readLock().lock();
        try {
            this.checkOrOpen();
            Long id = this.resources.computeIfAbsent(path, p -> this.newId());
            if (this.invalidated.contains(id)) {
                this.model.remove(id);
                this.modelComputed.remove(id);
                this.invalidated.remove(id);
                this.modelCache.invalidate((Object)path);
                this.modelComputedCache.invalidate((Object)path);
            }
            if (values == null) {
                this.interfaceCache.invalidate((Object)path);
                this.interfaceValues.remove(id);
            } else {
                this.interfaceCache.put((Object)path, List.copyOf(values));
                this.interfaceValues.put(id, values.stream().map(this::createFeatureValueCache).collect(Collectors.toList()));
            }
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    public void putModel(IPath path, Collection<FeatureValue> values) {
        if (path == null || path.isEmpty()) {
            return;
        }
        this.checkOrOpen();
        this.initializationLock.readLock().lock();
        try {
            Long id = this.resources.computeIfAbsent(path, p -> this.newId());
            if (this.invalidated.contains(id)) {
                this.interfaceValues.remove(id);
                this.modelComputed.remove(id);
                this.invalidated.remove(id);
                this.interfaceCache.invalidate((Object)path);
                this.modelComputedCache.invalidate((Object)path);
            }
            if (values == null) {
                this.modelCache.invalidate((Object)path);
                this.model.remove(id);
            } else {
                this.modelCache.put((Object)path, List.copyOf(values));
                this.model.put(id, values.stream().map(this::createFeatureValueCache).collect(Collectors.toList()));
            }
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    public void putModelComputed(IPath path, Collection<FeatureValue> values) {
        if (path == null || path.isEmpty()) {
            return;
        }
        this.checkOrOpen();
        this.initializationLock.readLock().lock();
        try {
            Long id = this.resources.computeIfAbsent(path, p -> this.newId());
            if (this.invalidated.contains(id)) {
                this.interfaceValues.remove(id);
                this.model.remove(id);
                this.invalidated.remove(id);
                this.interfaceCache.invalidate((Object)path);
                this.modelCache.invalidate((Object)path);
            }
            if (values == null) {
                this.modelComputedCache.invalidate((Object)path);
                this.modelComputed.remove(id);
            } else {
                this.modelComputedCache.put((Object)path, List.copyOf(values));
                this.modelComputed.put(id, values.stream().map(this::createFeatureValueCache).collect(Collectors.toList()));
            }
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOrOpen() {
        this.initializationLock.readLock().lock();
        try {
            if (this.initialized) {
                return;
            }
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
        this.initializationLock.writeLock().lock();
        try {
            ProjectCollectingCacheStore projectCollectingCacheStore = this;
            synchronized (projectCollectingCacheStore) {
                block20: {
                    if (!this.initialized) break block20;
                    return;
                }
                try {
                    this.open();
                }
                catch (Throwable e) {
                    String message = MessageFormat.format("Restart collecting cache because cannot open for project: {0}", this.project.getName());
                    IStatus status = CorePlugin.createErrorStatus(message, e);
                    CorePlugin.log(status);
                    try {
                        this.close();
                        this.delete();
                        this.open();
                    }
                    catch (Exception e2) {
                        CorePlugin.logError(e2);
                    }
                }
                if (!this.initialized) {
                    try {
                        this.delete();
                    }
                    catch (Exception e2) {
                        CorePlugin.logError(e2);
                    }
                    this.initImMemory();
                }
            }
        }
        finally {
            this.initializationLock.writeLock().unlock();
        }
    }

    private void internalOpen() {
        File fileIndex = ProjectCollectingCacheStore.getStorageFileIndex(this.project);
        try {
            Files.createDirectories(fileIndex.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            CorePlugin.logError(e);
        }
        this.dbIndex = this.openDb(fileIndex);
        PathSerializer pathSerializer = new PathSerializer();
        FeatureValueCacheEntryListSerializer keyListSerializer = new FeatureValueCacheEntryListSerializer();
        Atomic.Integer storageVersion = this.dbIndex.getAtomicInteger(VERSION_KEY);
        if (storageVersion.get() > 0 && storageVersion.get() != 1) {
            this.delete();
            this.dbIndex = this.openDb(fileIndex);
            storageVersion = this.dbIndex.getAtomicInteger(VERSION_KEY);
        }
        storageVersion.set(1);
        this.lastId = this.dbIndex.getAtomicLong("lastId");
        this.resources = this.dbIndex.createHashMap("resources").keySerializer((Serializer)pathSerializer).valueSerializer(Serializer.LONG).counterEnable().makeOrGet();
        this.invalidated = this.dbIndex.createHashSet("invalidated").serializer(Serializer.LONG).counterEnable().makeOrGet();
        this.lastFeauteId = this.dbIndex.getAtomicInteger("lastFeauteId");
        this.featureSettingsIds = this.dbIndex.createHashMap("featureSettingsIds").keySerializer(Serializer.STRING).valueSerializer(Serializer.INTEGER).counterEnable().makeOrGet();
        File fileInterface = ProjectCollectingCacheStore.getStorageFileInterface(this.project);
        try {
            Files.createDirectories(fileInterface.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            CorePlugin.logError(e);
        }
        this.dbInterface = DBMaker.newFileDB((File)fileInterface).transactionDisable().mmapFileEnableIfSupported().closeOnJvmShutdown().cacheDisable().cacheWeakRefEnable().make();
        this.interfaceValues = this.dbInterface.createTreeMap("interfacevalues").keySerializer(BTreeKeySerializer.ZERO_OR_POSITIVE_LONG).valueSerializer((Serializer)keyListSerializer).valuesOutsideNodesEnable().counterEnable().makeOrGet();
        File fileModel = ProjectCollectingCacheStore.getStorageFileModel(this.project);
        this.dbModel = DBMaker.newFileDB((File)fileModel).transactionDisable().mmapFileEnableIfSupported().closeOnJvmShutdown().cacheDisable().cacheWeakRefEnable().make();
        this.model = this.dbModel.createTreeMap("model").keySerializer(BTreeKeySerializer.ZERO_OR_POSITIVE_LONG).valueSerializer((Serializer)keyListSerializer).valuesOutsideNodesEnable().counterEnable().makeOrGet();
        File fileModelComputed = ProjectCollectingCacheStore.getStorageFileModelComputed(this.project);
        try {
            Files.createDirectories(fileModelComputed.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            CorePlugin.logError(e);
        }
        this.dbModelComputed = DBMaker.newFileDB((File)fileModelComputed).transactionDisable().mmapFileEnableIfSupported().closeOnJvmShutdown().cacheDisable().cacheWeakRefEnable().make();
        this.modelComputed = this.dbModelComputed.createTreeMap("modelComputed").keySerializer(BTreeKeySerializer.ZERO_OR_POSITIVE_LONG).valueSerializer((Serializer)keyListSerializer).valuesOutsideNodesEnable().counterEnable().makeOrGet();
    }

    private void initImMemory() {
        this.inMemoryLastId = new AtomicLong();
        this.resources = new ConcurrentHashMap<IPath, Long>();
        this.invalidated = new ConcurrentSkipListSet<Long>();
        this.interfaceValues = new ConcurrentHashMap<Long, Collection<FeatureValueCacheEntry>>();
        this.model = new ConcurrentHashMap<Long, Collection<FeatureValueCacheEntry>>();
        this.modelComputed = new ConcurrentHashMap<Long, Collection<FeatureValueCacheEntry>>();
        this.inMemory = true;
        this.initialized = true;
    }

    private DB openDb(File file) {
        return DBMaker.newFileDB((File)file).transactionDisable().closeOnJvmShutdown().asyncWriteEnable().asyncWriteFlushDelay(500).make();
    }

    private static File getStorageFileIndex(IProject project) {
        IPath path = Platform.getStateLocation((Bundle)CorePlugin.getDefault().getBundle());
        IPath folder = path.append(DB_FOLDER).append(project.getName());
        return folder.append(DB_FILE_NAME_INDEX).toFile();
    }

    private static File getStorageFileInterface(IProject project) {
        IPath path = Platform.getStateLocation((Bundle)CorePlugin.getDefault().getBundle());
        IPath folder = path.append(DB_FOLDER).append(project.getName());
        return folder.append(DB_FILE_NAME_INTERFACE).toFile();
    }

    private static File getStorageFileModel(IProject project) {
        IPath path = Platform.getStateLocation((Bundle)CorePlugin.getDefault().getBundle());
        IPath folder = path.append(DB_FOLDER).append(project.getName());
        return folder.append(DB_FILE_NAME_MODEL).toFile();
    }

    private static File getStorageFileModelComputed(IProject project) {
        IPath path = Platform.getStateLocation((Bundle)CorePlugin.getDefault().getBundle());
        IPath folder = path.append(DB_FOLDER).append(project.getName());
        return folder.append(DB_FILE_NAME_MODEL_COMPUTED).toFile();
    }

    private Long newId() {
        if (this.inMemory) {
            this.inMemoryLastId.incrementAndGet();
        }
        return this.lastId.incrementAndGet();
    }

    private FeatureValue createFeatureValue(IPath path, FeatureValueCacheEntry value, boolean computedValue) {
        FeatureSettings settings = null;
        String featureSettingsId = this.featureSettingsIdsBackMap.computeIfAbsent(value.getFeatureSettingsId(), key -> {
            for (Map.Entry<String, Integer> entry : this.featureSettingsIds.entrySet()) {
                if (!entry.getValue().equals(key)) continue;
                return entry.getKey();
            }
            return "";
        });
        if (StringUtils.isNotEmpty(featureSettingsId)) {
            settings = this.collectingServiceRegistry.getFeatureSettings(featureSettingsId);
        }
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.project, Path.fromPortableString((String)value.getResourceId()), SegmentFeatureKey.create(value.getFeatureKey()), settings, value.getValue());
        return new PersistableFeatureValue(contextKey, value.getComment(), computedValue, value.isUnknown(), value.isTag());
    }

    private FeatureValueCacheEntry createFeatureValueCache(FeatureValue value) {
        String featureSettingsId = this.collectingServiceRegistry.getFeatureSettingsId(value.getContextKey().getFeatureSettings());
        int id = this.featureSettingsIds.computeIfAbsent(featureSettingsId, key -> this.lastFeauteId.incrementAndGet());
        return new FeatureValueCacheEntry(value.getContextKey().getFeatureKey().getSegments().toArray(new String[0]), id, value.getContextKey().getValue(), value.getComment(), value.getContextKey().getResourceId().toPortableString(), value.isUnknown(), value.isTag());
    }
}

