/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.external;

import com.e1c.langtool.external.IExternalTranslationManager;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.external.INameProcessor;
import com.e1c.langtool.external.ITranslationProviderRegistry;
import com.e1c.langtool.external.cache.ITranslationCacheManager;
import com.e1c.langtool.external.cache.TranslationQueryEntity;
import com.e1c.langtool.external.cache.TranslationResultEntity;
import com.e1c.langtool.query.ContextTranslationQuery;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.query.IMultiTranslationQuery;
import com.e1c.langtool.query.ISingleTranslationQuery;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ExternalTranslationManager
implements IExternalTranslationManager {
    private static final int AMOUNT_TICKS = 100;
    private static final int PREPROCESS_TICKS = 10;
    private static final int POSTPROCESS_TICKS = 10;
    private static final int TRANSLATE_WITH_PROCESSING_TICKS = 80;
    private static final int TRANSLATE_TICKS = 100;
    @Inject
    private ITranslationProviderRegistry providersManager;
    @Inject
    private INameProcessor nameProcessor;
    @Inject
    private ITranslationCacheManager.ITranslationCache cache;

    @Override
    public ITranslationProviderRegistry getTranslationProviderRegistry() {
        return this.providersManager;
    }

    @Override
    public List<String> translate(ISingleTranslationQuery query, String providerId, IProgressMonitor monitor) {
        List<String> result;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (query.isProcessingNeeded() && this.isTextProcessable(providerId)) {
            String processedString = this.nameProcessor.preProcess(query.getText());
            subMonitor.worked(10);
            result = this.translate(processedString, query.getSourceLanguage(), query.getTargetLanguage(), providerId);
            subMonitor.worked(80);
            result = result.stream().map(this.nameProcessor::postProcess).collect(Collectors.toList());
            subMonitor.worked(10);
        } else if (query instanceof IContextTranslationQuery) {
            result = this.translate((IContextTranslationQuery)query, providerId, (IProgressMonitor)subMonitor);
        } else {
            result = this.translate(query.getText(), query.getSourceLanguage(), query.getTargetLanguage(), providerId);
            subMonitor.worked(100);
        }
        return result;
    }

    @Override
    public List<String> translate(IContextTranslationQuery query, String providerId, IProgressMonitor monitor) {
        List<String> translations;
        boolean textProcessable;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean bl = textProcessable = query.isProcessingNeeded() && this.isTextProcessable(providerId);
        if (textProcessable) {
            query = ContextTranslationQuery.Builder.valueOf(query).text(this.nameProcessor.preProcess(query.getText())).build();
            subMonitor.worked(10);
        }
        if (this.isCacheable(providerId)) {
            TranslationQueryEntity queryEntity = new TranslationQueryEntity(providerId, query.getSourceLanguage(), query.getTargetLanguage(), query.getText());
            TranslationResultEntity cachedResult = (TranslationResultEntity)this.cache.get(queryEntity);
            if (cachedResult == null) {
                IExternalTranslationProvider provider = this.getProviderById(providerId);
                translations = provider.translate(query);
                this.cache.put(queryEntity, new TranslationResultEntity(translations));
            } else {
                translations = cachedResult.getTranslations();
            }
        } else {
            translations = this.getProviderById(providerId).translate(query);
            subMonitor.worked(80);
        }
        if (textProcessable) {
            translations = translations.stream().map(this.nameProcessor::postProcess).collect(Collectors.toList());
            subMonitor.worked(10);
        }
        subMonitor.worked(100);
        return translations;
    }

    @Override
    public Map<String, List<String>> translate(IMultiTranslationQuery query, String providerId, IProgressMonitor monitor) {
        Map<String, List<String>> result;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (query.isProcessingNeeded() && this.isTextProcessable(providerId)) {
            List<String> texts = new ArrayList<String>(query.getTexts());
            texts = texts.stream().map(this.nameProcessor::preProcess).collect(Collectors.toList());
            subMonitor.worked(10);
            result = this.translate(texts, query.getSourceLanguage(), query.getTargetLanguage(), providerId);
            subMonitor.worked(80);
            for (Map.Entry<String, List<String>> entry : result.entrySet()) {
                List values = entry.getValue().stream().map(this.nameProcessor::postProcess).collect(Collectors.toList());
                entry.setValue(values);
            }
            subMonitor.worked(10);
        } else {
            result = this.translate(query.getTexts(), query.getSourceLanguage(), query.getTargetLanguage(), providerId);
            subMonitor.worked(100);
        }
        return result;
    }

    @Override
    public List<String> getSupportedLanguages(String providerId, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IExternalTranslationProvider provider = this.getProviderById(providerId);
        ArrayList<String> languages = new ArrayList<String>(provider.getLanguageCodes());
        subMonitor.worked(100);
        return languages;
    }

    private List<String> translate(String text, String source, String target, String providerId) {
        List<String> translations;
        TranslationQueryEntity queryEntity = new TranslationQueryEntity(providerId, source, target, text);
        if (!this.isCacheable(providerId)) {
            IExternalTranslationProvider provider = this.getProviderById(providerId);
            translations = provider.translate(text, source, target);
        } else {
            TranslationResultEntity cachedResult = (TranslationResultEntity)this.cache.get(queryEntity);
            if (cachedResult == null) {
                IExternalTranslationProvider provider = this.getProviderById(providerId);
                translations = provider.translate(text, source, target);
                this.cache.put(queryEntity, new TranslationResultEntity(translations));
            } else {
                translations = cachedResult.getTranslations();
            }
        }
        return translations;
    }

    private Map<String, List<String>> translate(List<String> texts, String source, String target, String providerId) {
        Map<String, List<String>> translations;
        LinkedList<String> notCachedTexts = new LinkedList<String>();
        if (this.isCacheable(providerId)) {
            HashMap<String, List<String>> cachedTranslations = new HashMap<String, List<String>>();
            for (String text : texts) {
                TranslationQueryEntity query = new TranslationQueryEntity(providerId, source, target, text);
                TranslationResultEntity result = (TranslationResultEntity)this.cache.get(query);
                if (result != null) {
                    cachedTranslations.put(text, result.getTranslations());
                    continue;
                }
                notCachedTexts.add(text);
            }
            if (notCachedTexts.isEmpty()) {
                return cachedTranslations;
            }
            IExternalTranslationProvider provider = this.getProviderById(providerId);
            translations = provider.translate(notCachedTexts, source, target);
            translations.putAll(cachedTranslations);
        } else {
            IExternalTranslationProvider provider = this.getProviderById(providerId);
            translations = provider.translate(notCachedTexts, source, target);
        }
        return translations;
    }

    private IExternalTranslationProvider getProviderById(String providerId) {
        return this.providersManager.getExternalTranslationProvider(providerId);
    }

    private boolean isCacheable(String providerId) {
        return this.providersManager.getExternalTranslationProviderAttrs(providerId).isCacheable();
    }

    private boolean isTextProcessable(String providerId) {
        return this.providersManager.getExternalTranslationProviderAttrs(providerId).isTextProcessable();
    }
}

