/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.external.cache;

import com.e1c.langtool.external.cache.ITranslationCacheManager;
import com.e1c.langtool.external.cache.TranslationQueryEntity;
import com.e1c.langtool.external.cache.TranslationResultEntity;
import com.e1c.langtool.internal.external.cache.TranslationCacheManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SharedTranslationCache
extends TranslationCacheManager
implements ITranslationCacheManager.ITranslationCache {
    @Override
    public synchronized void put(TranslationQueryEntity key, TranslationResultEntity value) {
        this.putIfExists(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends TranslationQueryEntity, ? extends TranslationResultEntity> map) {
        for (Map.Entry<? extends TranslationQueryEntity, ? extends TranslationResultEntity> entry : map.entrySet()) {
            this.putIfExists(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized TranslationResultEntity get(TranslationQueryEntity key) {
        ITranslationCacheManager.ITranslationCache cache = this.getCacheByProviderId(key.getProviderId());
        if (cache != null) {
            return (TranslationResultEntity)cache.get(key);
        }
        return null;
    }

    @Override
    public synchronized Map<TranslationQueryEntity, TranslationResultEntity> getAll() {
        HashMap<TranslationQueryEntity, TranslationResultEntity> result = new HashMap<TranslationQueryEntity, TranslationResultEntity>();
        this.getCaches().values().forEach(cache -> result.putAll(cache.getAll()));
        return result;
    }

    @Override
    public synchronized void remove(TranslationQueryEntity key) {
        ITranslationCacheManager.ITranslationCache cache = this.getCacheByProviderId(key.getProviderId());
        if (cache != null) {
            cache.remove(key);
        }
    }

    @Override
    public synchronized void removeAll(Iterator<?> keys) {
        this.getCaches().values().forEach(cache -> cache.removeAll());
    }

    @Override
    public synchronized void removeAll() {
        this.getCaches().values().forEach(cache -> cache.removeAll());
    }

    @Override
    public synchronized long size() {
        long sizes = 0L;
        for (ITranslationCacheManager.ITranslationCache cache : this.getCaches().values()) {
            sizes += cache.size();
        }
        return sizes;
    }

    private void putIfExists(TranslationQueryEntity key, TranslationResultEntity value) {
        ITranslationCacheManager.ITranslationCache cache = this.getCacheByProviderId(key.getProviderId());
        if (cache != null) {
            cache.put(key, value);
        }
    }
}

