/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.external.cache;

import com.e1c.langtool.external.ITranslationProviderRegistry;
import com.e1c.langtool.external.cache.ITranslationCacheManager;
import com.e1c.langtool.external.cache.TranslationCache;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.external.cache.CacheStub;
import com.e1c.langtool.internal.external.cache.LazyLoadingInvocationHandler;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOError;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;

public class TranslationCacheManager
implements ITranslationCacheManager {
    private static final String WORKSPACE_PATH = Paths.get(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString(), ".metadata").toString();
    @Inject
    private ITranslationProviderRegistry providersRegistry;
    private Map<String, ITranslationCacheManager.ITranslationCache> caches;

    @Override
    public synchronized ITranslationCacheManager.ITranslationCache getCacheByProviderId(String providerId) {
        return this.getCaches().get(providerId);
    }

    @Override
    public synchronized void setCache(String providerId, ITranslationCacheManager.ITranslationCache cache) {
        if (providerId == null) {
            throw new IllegalArgumentException("The provider's id can't be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("The cache can't be null");
        }
        this.getCaches().put(providerId, cache);
    }

    protected Map<String, ITranslationCacheManager.ITranslationCache> getCaches() {
        if (this.caches == null) {
            this.caches = Maps.newHashMap();
            List<String> cacheableProviders = this.providersRegistry.getExternalTranslationProvidersIds(attrs -> attrs.isCacheable());
            for (String providerId : cacheableProviders) {
                try {
                    File providerDir = new File(Paths.get(WORKSPACE_PATH, providerId).toString());
                    if (!providerDir.exists()) {
                        providerDir.mkdir();
                    }
                    this.caches.put(providerId, this.createCacheProxy(providerDir.toString(), providerId));
                }
                catch (IOError exc) {
                    CorePlugin.logError(exc);
                }
            }
        }
        return this.caches;
    }

    private ITranslationCacheManager.ITranslationCache createCacheProxy(String path, String providerId) {
        ClassLoader classLoader = ITranslationCacheManager.ITranslationCache.class.getClassLoader();
        Provider factory = () -> {
            try {
                return new TranslationCache(path, providerId);
            }
            catch (IOError exc) {
                CorePlugin.logError(exc);
                return new CacheStub();
            }
        };
        ITranslationCacheManager.ITranslationCache cache = (ITranslationCacheManager.ITranslationCache)Proxy.newProxyInstance(classLoader, new Class[]{ITranslationCacheManager.ITranslationCache.class}, (InvocationHandler)new LazyLoadingInvocationHandler(factory));
        return cache;
    }
}

