/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ignore;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.ignore.IgnoreTranslationChecker;
import com.e1c.langtool.ignore.IgnoreTranslationCheckingService;
import com.e1c.langtool.internal.CorePlugin;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

@Singleton
public class IgnoreCheckingService
implements IgnoreTranslationCheckingService {
    public static final String EXTENSION_POINT_ID = "ignoreTranslationChecker";
    private static final String ATT_CLASS = "class";
    private volatile Collection<IgnoreTranslationChecker> checkers;

    @Override
    public boolean ignoreTranslation(IProject project, TranslationSource source, IProgressMonitor monitor) {
        for (IgnoreTranslationChecker checker : this.getCheckers()) {
            if (monitor.isCanceled()) break;
            if (!checker.ignoreTranslation(project, source, monitor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean ignoreTranslation(IProject project, TranslationSource source, FeatureKey featureKey, IProgressMonitor monitor) {
        for (IgnoreTranslationChecker checker : this.getCheckers()) {
            if (monitor.isCanceled()) break;
            if (!checker.ignoreTranslation(project, source, featureKey, monitor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean ignoreTranslation(IProject project, ContextTranslationKey source, IProgressMonitor monitor) {
        for (IgnoreTranslationChecker checker : this.getCheckers()) {
            if (monitor.isCanceled()) break;
            if (!checker.ignoreTranslation(project, source, monitor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean ignoreTranslation(IProject project, IPath resourceId, FeatureKey featureKey, IProgressMonitor monitor) {
        for (IgnoreTranslationChecker checker : this.getCheckers()) {
            if (monitor.isCanceled()) break;
            if (!checker.ignoreTranslation(project, resourceId, featureKey, monitor)) continue;
            return true;
        }
        return false;
    }

    private Collection<IgnoreTranslationChecker> getCheckers() {
        if (this.checkers == null) {
            this.checkers = this.loadCheckers();
        }
        return this.checkers;
    }

    private synchronized Collection<IgnoreTranslationChecker> loadCheckers() {
        IConfigurationElement[] configElements;
        LinkedList allCheckers = Lists.newLinkedList();
        IConfigurationElement[] elements = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool", EXTENSION_POINT_ID);
        int length = configElements.length;
        int index = 0;
        while (index < length) {
            IConfigurationElement configElement = elements[index];
            try {
                IgnoreTranslationChecker e = (IgnoreTranslationChecker)configElement.createExecutableExtension(ATT_CLASS);
                allCheckers.add(e);
            }
            catch (CoreException e) {
                CorePlugin.logError(e);
            }
            ++index;
        }
        return allCheckers;
    }
}

