/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.platform;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.platform.ITranslateProjectFactory;
import com.e1c.langtool.platform.ITranslatingProject;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

@Singleton
public class TranslateProjectFactoryService {
    private static final String EXTENSION_POINT_ID = "com.e1c.langtool.translateProjectFactories";
    private static final String ATT_CLASS = "class";
    private static final String ELEMENT_NATRURE_NAME = "nature";
    private static final String ELEMENT_NATURE_ID = "id";
    private volatile Map<String, ITranslateProjectFactory> factories;

    public ITranslatingProject createTranslatingProject(IProject project) {
        IProjectDescription description;
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            CorePlugin.logError(e);
            return null;
        }
        String[] natures = description.getNatureIds();
        if (!TranslateProjectFactoryService.hasTranslatingNature(natures)) {
            return null;
        }
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            ITranslateProjectFactory factory;
            String nature = stringArray[n2];
            if (nature != null && !nature.equals("com.e1c.langtool.TranslatingNature") && (factory = this.getFactories().get(nature)) != null) {
                return factory.createTranslatingProject(project);
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ITranslateProjectFactory> getFactories() {
        Class<TranslateProjectFactoryService> clazz;
        if (this.factories != null) {
            return this.factories;
        }
        Class<TranslateProjectFactoryService> clazz2 = clazz = TranslateProjectFactoryService.class;
        synchronized (clazz2) {
            IConfigurationElement[] configElements;
            if (this.factories != null) {
                return this.factories;
            }
            HashMap allFactories = Maps.newHashMap();
            IConfigurationElement[] elements = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
            int length = configElements.length;
            int index = 0;
            while (index < length) {
                IConfigurationElement configElement = elements[index];
                try {
                    ITranslateProjectFactory e = (ITranslateProjectFactory)configElement.createExecutableExtension(ATT_CLASS);
                    IConfigurationElement[] natures = configElement.getChildren(ELEMENT_NATRURE_NAME);
                    int i = 0;
                    while (i < natures.length) {
                        IConfigurationElement nature = natures[i];
                        String natureId = nature.getAttribute(ELEMENT_NATURE_ID);
                        if (StringUtils.isNotEmpty(natureId)) {
                            allFactories.put(natureId, e);
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    CorePlugin.logError(e);
                }
                ++index;
            }
            this.factories = allFactories;
            return this.factories;
        }
    }

    private static boolean hasTranslatingNature(String[] natures) {
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature != null && nature.equals("com.e1c.langtool.TranslatingNature")) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

