/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.platform;

import com.e1c.langtool.internal.platform.NonTranslatedProject;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatedProjectManager;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslatingProjectChangeListener;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;

public class TranslatedProjectManager
implements ITranslatedProjectManager {
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    private Map<IProject, ITranslatedProject> projects = new ConcurrentHashMap<IProject, ITranslatedProject>();
    private IResourceChangeListener projectChangeListener = new ProjectChangeListener();
    private TranslatingProjectChangeListener translatingListener = event -> this.updateProjects(event.getProject());

    public void activate() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projectChangeListener, 6);
        this.translatingProjectManager.addPostChangeListener(this.translatingListener);
    }

    public void deactivate() {
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.projectChangeListener);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.translatingProjectManager.removePostChangeListener(this.translatingListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITranslatedProject getProject(IProject project) {
        Map<IProject, ITranslatedProject> map = this.projects;
        synchronized (map) {
            ITranslatedProject translatedProject = this.projects.get(project);
            if (translatedProject != null && translatedProject.isTranslated() && (translatedProject.getSourceProject() == null || !translatedProject.getSourceProject().getTranslatedProjects().contains(translatedProject))) {
                this.projects.remove(project);
                translatedProject = null;
            }
            if (translatedProject != null) {
                return translatedProject;
            }
            IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < allProjects.length) {
                IProject iProject = allProjects[i];
                ITranslatingProject sourceProject = this.translatingProjectManager.getProject(iProject);
                if (sourceProject.isTranslating() && !sourceProject.getTranslatedProjects().isEmpty()) {
                    for (ITranslatedProject translatedProject2 : sourceProject.getTranslatedProjects()) {
                        if (!project.getName().equals(translatedProject2.getProjectName())) continue;
                        this.projects.put(project, translatedProject2);
                        return translatedProject2;
                    }
                }
                ++i;
            }
            translatedProject = new NonTranslatedProject(project);
            this.projects.put(project, translatedProject);
            return translatedProject;
        }
    }

    @Override
    public ITranslatedProject getProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return this.getProject(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProjects(ITranslatingProject sourceProject) {
        Map<IProject, ITranslatedProject> map = this.projects;
        synchronized (map) {
            if (!sourceProject.isTranslating() || sourceProject.getTranslatedProjects().isEmpty()) {
                Iterator<Map.Entry<IProject, ITranslatedProject>> iterator = this.projects.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<IProject, ITranslatedProject> entry = iterator.next();
                    if (!entry.getValue().isTranslated() && (entry.getValue().getSourceProject() == null || !sourceProject.getProject().equals((Object)entry.getValue().getSourceProject().getProject()))) continue;
                    iterator.remove();
                }
            } else {
                for (ITranslatedProject project : sourceProject.getTranslatedProjects()) {
                    ITranslatedProject registred = this.projects.get(project.getProject());
                    if (registred == null || project.equals(registred)) continue;
                    this.projects.remove(project.getProject());
                }
            }
        }
    }

    private class ProjectChangeListener
    implements IResourceChangeListener {
        private ProjectChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            IResource res = event.getResource();
            if ((event.getType() == 2 || event.getType() == 4) && res instanceof IProject) {
                Map<IProject, ITranslatedProject> map = TranslatedProjectManager.this.projects;
                synchronized (map) {
                    ITranslatedProject project = TranslatedProjectManager.this.projects.get(res);
                    if (project != null) {
                        TranslatedProjectManager.this.projects.remove(res);
                    }
                }
            }
        }
    }
}

