/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.settings;

import com.e1c.langtool.settings.FeatureValueValidator;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class CompositeValidator
implements FeatureValueValidator {
    private final Collection<FeatureValueValidator> validators;

    public CompositeValidator(Collection<FeatureValueValidator> validators) {
        this.validators = validators;
    }

    @Override
    public IStatus isValid(String value, FeatureValueValidator.ValidationContext context) {
        MultiStatus errors = new MultiStatus("com.e1c.langtool", 0, "Ok", null);
        for (FeatureValueValidator validator : this.validators) {
            IStatus status = validator.isValid(value, context);
            if (status.isOK()) continue;
            errors.merge(status);
        }
        return errors;
    }

    @Override
    public String preprocessValue(String value, FeatureValueValidator.ValidationContext context) {
        String newValue = value;
        for (FeatureValueValidator validator : this.validators) {
            newValue = validator.preprocessValue(newValue, context);
        }
        return newValue;
    }
}

