/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.storage;

import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractStorageTranslationProvider
implements IExternalTranslationProvider {
    @Inject
    protected ITranslatingProjectManager translatingProjectManager;
    @Inject
    private ITranslationStorageManager storageManager;

    @Override
    public Set<String> getLanguageCodes() {
        HashSet<String> result = new HashSet<String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            @NonNull ITranslatingProject translating = this.translatingProjectManager.getProject(project);
            if (translating.isTranslating()) {
                result.add(translating.getDefaultLanguage().getLanguageCode());
                translating.getInterfaceLanguages().forEach(l -> {
                    boolean bl = result.add(l.getLanguageCode());
                });
            }
            ++i;
        }
        return result;
    }

    @Override
    public Map<String, String> getLanguages(String targetLocale) {
        if (targetLocale == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            @NonNull ITranslatingProject translating = this.translatingProjectManager.getProject(project);
            if (translating.isTranslating() && targetLocale.equals(translating.getDefaultLanguage().getLanguageCode())) {
                translating.getInterfaceLanguages().forEach(l -> {
                    String string = result.put(l.getLanguageCode(), l.getPresentation());
                });
            }
            ++i;
        }
        return result;
    }

    protected Pair<ITranslatingProject, TranslateLanguage> getTargetProjectAndLanguage(String projectName, String sourceLocale, String targetLocale, FeatureSettings settings) {
        ITranslatingProject translating = this.translatingProjectManager.getProject(projectName);
        if (!translating.isTranslating() || sourceLocale == null || targetLocale == null || !sourceLocale.equals(translating.getDefaultLanguage().getLanguageCode())) {
            return null;
        }
        TranslateLanguage target = null;
        for (TranslateLanguage language : translating.getInterfaceLanguages()) {
            if (settings != null && !TranslationUtils.isValidFeatureForLanguage(settings, language) || !targetLocale.equals(language.getLanguageCode())) continue;
            target = language;
            break;
        }
        if (target != null) {
            return new Pair<ITranslatingProject, Object>(translating, target);
        }
        return null;
    }

    protected List<String> translate(IProject project, TranslationKey key, TranslateLanguage target, ITranslationStorageProvider.Storage.Type ... storageTypes) {
        IProjectTranslationReader reader = this.storageManager.getTranslationReader(project);
        String translation = reader.getStoredTranslation(key, target, storageTypes);
        return Lists.newArrayList((Object[])new String[]{translation});
    }
}

