/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.storage;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.storage.Messages;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageSettingsChangeListener;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.IStorageValueChangedListener;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.StorageValueChangeEvent;
import com.e1c.langtool.storage.model.EditSettings;
import com.e1c.langtool.storage.model.ProjectStorageSettings;
import com.e1c.langtool.storage.model.RuleSettings;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import com.google.common.hash.HashFunction;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;

public class DefaultEditingStorageProvider
implements ITranslationStorageProvider {
    public static final String PROVIDER_ID = "edit";
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    @Inject
    private ITranslationStorageManager storageManager;
    private final IStorageSettingsChangeListener settingsChangeListener = this::settingsChanged;
    private final Map<IProject, DefaultEditingStorage> storageSegments = new ConcurrentHashMap<IProject, DefaultEditingStorage>();

    @Override
    public String getProviderId() {
        return PROVIDER_ID;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void initialize(IProject project, List<String> segments) {
        this.storageSettingsManager.addChangeListener(this.settingsChangeListener);
    }

    @Override
    public List<String> getStorageSegments(IProject project) {
        return Arrays.asList("default");
    }

    @Override
    public String getStorageDescription(IProject project, String segment) {
        EditSettings settings;
        if ("default".equals(segment) && StringUtils.isNotEmpty((settings = this.getEditSettings(project)).getPresentation())) {
            return settings.getPresentation();
        }
        return Messages.DefaultEditingStorageProvider_default_description;
    }

    private EditSettings getEditSettings(IProject project) {
        ProjectStorageSettings settings = this.storageSettingsManager.getSettingsOrDefault(project);
        return settings.getEdit();
    }

    @Override
    public ITranslationStorageProvider.Storage getStorage(IProject project, String segment) {
        if ("default".equals(segment)) {
            return this.storageSegments.computeIfAbsent(project, p -> {
                DefaultEditingStorage storage = new DefaultEditingStorage(project);
                this.storageSettingsManager.addChangeListener(this.settingsChangeListener);
                return storage;
            });
        }
        return null;
    }

    private void settingsChanged(IProject project, boolean projectClosed) {
        this.storageSegments.remove(project);
        if (this.storageSegments.isEmpty()) {
            this.storageSettingsManager.removeChangeListener(this.settingsChangeListener);
        }
    }

    private final class DefaultEditingStorage
    implements ITranslationStorageProvider.ContextStorage {
        private final IProject project;
        private final ListenerList<IStorageValueChangedListener> valueChangedListeners = new ListenerList();
        private volatile List<StorageSettings> storageSettings;
        private volatile EditSettings editSettings;
        private volatile Map<StorageID, StorageSettings> allSettings;
        private AtomicBoolean batchUpdate = new AtomicBoolean();

        public DefaultEditingStorage(IProject project) {
            this.project = project;
        }

        @Override
        public StorageID getId() {
            return StorageSettingsUtils.EDIT_DEFAULT_STORAGE_ID;
        }

        @Override
        public String getSegment() {
            return "default";
        }

        @Override
        public void addValueChangedListener(IStorageValueChangedListener listener) {
            this.valueChangedListeners.add((Object)listener);
            for (StorageID id : this.getStorageIds()) {
                ITranslationStorageProvider.Storage storage = DefaultEditingStorageProvider.this.storageManager.getStorage(this.project, id);
                if (storage == null) continue;
                storage.addValueChangedListener(listener);
            }
        }

        @Override
        public void removeValueChangedListener(IStorageValueChangedListener listener) {
            this.valueChangedListeners.remove((Object)listener);
            for (StorageID id : this.getStorageIds()) {
                ITranslationStorageProvider.Storage storage = DefaultEditingStorageProvider.this.storageManager.getStorage(this.project, id);
                if (storage == null) continue;
                storage.removeValueChangedListener(listener);
            }
        }

        @Override
        public synchronized void beginBatchUpdate() {
            this.batchUpdate.set(true);
            for (StorageID id : this.getStorageIds()) {
                ITranslationStorageProvider.Storage storage = DefaultEditingStorageProvider.this.storageManager.getStorage(this.project, id);
                if (storage == null) continue;
                storage.beginBatchUpdate();
            }
        }

        @Override
        public synchronized void endBatchUpdate() {
            this.batchUpdate.set(false);
            for (StorageID id : this.getStorageIds()) {
                ITranslationStorageProvider.Storage storage = DefaultEditingStorageProvider.this.storageManager.getStorage(this.project, id);
                if (storage == null) continue;
                storage.endBatchUpdate();
            }
        }

        @Override
        public String getTranslation(ContextTranslationKey key, TranslateLanguage language) {
            StorageID id = this.getFirstStorageId(key, language);
            if (id == null) {
                return "";
            }
            ITranslationStorageProvider.Storage storage = DefaultEditingStorageProvider.this.storageManager.getStorage(this.project, id);
            if (key instanceof FeatureValue && storage != null) {
                return storage.getTranslation((FeatureValue)key, language);
            }
            if (storage instanceof ITranslationStorageProvider.ContextStorage) {
                return ((ITranslationStorageProvider.ContextStorage)storage).getTranslation(key, language);
            }
            if (storage instanceof ITranslationStorageProvider.DictionaryStorage) {
                return ((ITranslationStorageProvider.DictionaryStorage)storage).getTranslation(key, language);
            }
            return "";
        }

        @Override
        public void setTranslation(ContextTranslationKey key, TranslateLanguage language, String translation, boolean autoSave) {
            StorageID id = this.getFirstStorageId(key, language);
            if (id == null) {
                return;
            }
            ITranslationStorageProvider.Storage storage = DefaultEditingStorageProvider.this.storageManager.getStorage(this.project, id);
            if (key instanceof FeatureValue && storage != null) {
                storage.setTranslation((FeatureValue)key, language, translation, autoSave);
            } else if (storage instanceof ITranslationStorageProvider.ContextStorage) {
                ((ITranslationStorageProvider.ContextStorage)storage).setTranslation(key, language, translation, autoSave);
            } else if (storage instanceof ITranslationStorageProvider.DictionaryStorage) {
                ((ITranslationStorageProvider.DictionaryStorage)storage).setTranslation(key, language, translation, autoSave);
            }
            this.firePostValueChanged(new StorageValueChangeEvent(this, this.getEditSettings().getStorageId(), key, language, null, translation));
        }

        @Override
        public void removeTranslation(ContextTranslationKey key, TranslateLanguage language, boolean autoSave) {
            StorageID id = this.getFirstStorageId(key, language);
            if (id == null) {
                return;
            }
            ITranslationStorageProvider.Storage storage = DefaultEditingStorageProvider.this.storageManager.getStorage(this.project, id);
            if (key instanceof FeatureValue && storage != null) {
                storage.removeTranslation((FeatureValue)key, language, autoSave);
            } else if (storage instanceof ITranslationStorageProvider.ContextStorage) {
                ((ITranslationStorageProvider.ContextStorage)storage).removeTranslation(key, language, autoSave);
            } else if (storage instanceof ITranslationStorageProvider.DictionaryStorage) {
                ((ITranslationStorageProvider.DictionaryStorage)storage).removeTranslation(key, language, autoSave);
            }
            this.firePostValueChanged(new StorageValueChangeEvent(this, this.getEditSettings().getStorageId(), key, language, null, null));
        }

        @Override
        public void moveTranslation(ContextTranslationKey fromKey, ContextTranslationKey toKey, TranslateLanguage language, boolean autoSave) {
            String translation = this.getTranslation(fromKey, language);
            if (StringUtils.isNotEmpty(translation)) {
                this.removeTranslation(fromKey, language, autoSave);
                this.setTranslation(toKey, language, translation, autoSave);
                this.firePostValueChanged(new StorageValueChangeEvent(this, this.getEditSettings().getStorageId(), fromKey, language, translation, null));
                this.firePostValueChanged(new StorageValueChangeEvent(this, this.getEditSettings().getStorageId(), toKey, language, null, translation));
            }
        }

        @Override
        public String getComment(ContextTranslationKey key, TranslateLanguage language) {
            StorageID id = this.getFirstStorageId(key, language);
            if (id == null) {
                return "";
            }
            ITranslationStorageProvider.Storage storage = DefaultEditingStorageProvider.this.storageManager.getStorage(this.project, id);
            if (storage instanceof ITranslationStorageProvider.ContextStorage) {
                return ((ITranslationStorageProvider.ContextStorage)storage).getComment(key, language);
            }
            if (storage instanceof ITranslationStorageProvider.DictionaryStorage) {
                return ((ITranslationStorageProvider.DictionaryStorage)storage).getComment(key, language);
            }
            return "";
        }

        @Override
        public void setComment(ContextTranslationKey key, TranslateLanguage language, String comment, boolean autoSave) {
            StorageID id = this.getFirstStorageId(key, language);
            if (id == null) {
                return;
            }
            ITranslationStorageProvider.Storage storage = DefaultEditingStorageProvider.this.storageManager.getStorage(this.project, id);
            if (storage instanceof ITranslationStorageProvider.ContextStorage) {
                ((ITranslationStorageProvider.ContextStorage)storage).setComment(key, language, comment, autoSave);
            } else if (storage instanceof ITranslationStorageProvider.DictionaryStorage) {
                ((ITranslationStorageProvider.DictionaryStorage)storage).setComment(key, language, comment, autoSave);
            }
            this.firePostValueChanged(new StorageValueChangeEvent(this, this.getEditSettings().getStorageId(), key, language, null, null));
        }

        @Override
        public void removeComment(ContextTranslationKey key, TranslateLanguage language, boolean autoSave) {
            StorageID id = this.getFirstStorageId(key, language);
            if (id == null) {
                return;
            }
            ITranslationStorageProvider.Storage storage = DefaultEditingStorageProvider.this.storageManager.getStorage(this.project, id);
            if (storage instanceof ITranslationStorageProvider.ContextStorage) {
                ((ITranslationStorageProvider.ContextStorage)storage).removeComment(key, language, autoSave);
            } else if (storage instanceof ITranslationStorageProvider.DictionaryStorage) {
                ((ITranslationStorageProvider.DictionaryStorage)storage).removeComment(key, language, autoSave);
            }
            this.firePostValueChanged(new StorageValueChangeEvent(this, this.getEditSettings().getStorageId(), key, language, null, null));
        }

        @Override
        public void moveComment(ContextTranslationKey fromKey, ContextTranslationKey toKey, TranslateLanguage language, boolean autoSave) {
            String comment = this.getComment(fromKey, language);
            this.removeComment(fromKey, language, autoSave);
            this.setComment(toKey, language, comment, autoSave);
        }

        @Override
        public boolean hasKeyForValue(String value, TranslateLanguage language, ContextTranslationKey skipTranslationKey) {
            return false;
        }

        @Override
        public Map<IFile, byte[]> saveFiles(Collection<ContextTranslationKey> affectedKeys, TranslateLanguage language, HashFunction hashFunction) {
            HashSet<ITranslationStorageProvider.Storage> affectedStorages = new HashSet<ITranslationStorageProvider.Storage>();
            for (ContextTranslationKey key : affectedKeys) {
                ITranslationStorageProvider.Storage storage;
                StorageID id = this.getFirstStorageId(key, language);
                if (id == null || (storage = DefaultEditingStorageProvider.this.storageManager.getStorage(this.project, id)) == null) continue;
                affectedStorages.add(storage);
            }
            HashMap<IFile, byte[]> results = new HashMap<IFile, byte[]>();
            for (ITranslationStorageProvider.Storage storage : affectedStorages) {
                if (storage instanceof ITranslationStorageProvider.ContextStorage) {
                    results.putAll(((ITranslationStorageProvider.ContextStorage)storage).saveFiles(affectedKeys, language, hashFunction));
                    continue;
                }
                if (!(storage instanceof ITranslationStorageProvider.DictionaryStorage)) continue;
                System.out.println("Hereh!");
            }
            return results;
        }

        protected void firePostValueChanged(StorageValueChangeEvent event) {
            if (this.batchUpdate.get()) {
                return;
            }
            for (IStorageValueChangedListener l : this.valueChangedListeners) {
                try {
                    SafeRunner.run(() -> l.changed(event));
                }
                catch (Throwable e) {
                    CorePlugin.logError(e);
                }
            }
        }

        private StorageID getFirstStorageId(ContextTranslationKey key, TranslateLanguage language) {
            for (StorageSettings settings : this.getStorageSettings()) {
                if (settings.isReadOnly() || !StorageSettingsUtils.canStoreFeature(settings, key.getFeatureSettings())) continue;
                return settings.getStorageId();
            }
            for (RuleSettings rule : this.getEditSettings().getRulesSettings()) {
                if (!StorageSettingsUtils.canStoreByRule(rule, key, language)) continue;
                for (StorageID id : rule.getStorageIds()) {
                    StorageSettings settings = this.getAllStorageSettings().get(id);
                    if (settings == null || settings.isReadOnly() || !StorageSettingsUtils.canStoreFeature(settings, key.getFeatureSettings())) continue;
                    return settings.getStorageId();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EditSettings getEditSettings() {
            if (this.editSettings == null) {
                DefaultEditingStorage defaultEditingStorage = this;
                synchronized (defaultEditingStorage) {
                    if (this.editSettings != null) {
                        return this.editSettings;
                    }
                    ProjectStorageSettings projectSettings = DefaultEditingStorageProvider.this.storageSettingsManager.getSettingsOrDefault(this.project);
                    this.editSettings = projectSettings.getEdit();
                }
            }
            return this.editSettings;
        }

        private List<StorageID> getStorageIds() {
            return this.getEditSettings().allStorageIds();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<StorageSettings> getStorageSettings() {
            if (this.storageSettings == null) {
                DefaultEditingStorage defaultEditingStorage = this;
                synchronized (defaultEditingStorage) {
                    if (this.storageSettings != null) {
                        return this.storageSettings;
                    }
                    ProjectStorageSettings settings = DefaultEditingStorageProvider.this.storageSettingsManager.getSettingsOrDefault(this.project);
                    this.storageSettings = settings.getEdit().getStorageIDs().stream().map(settings.allStorageSettings()::get).filter(Objects::nonNull).collect(Collectors.toList());
                }
            }
            return this.storageSettings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<StorageID, StorageSettings> getAllStorageSettings() {
            if (this.allSettings == null) {
                DefaultEditingStorage defaultEditingStorage = this;
                synchronized (defaultEditingStorage) {
                    if (this.allSettings != null) {
                        return this.allSettings;
                    }
                    ProjectStorageSettings projectSettings = DefaultEditingStorageProvider.this.storageSettingsManager.getSettingsOrDefault(this.project);
                    this.allSettings = projectSettings.allStorageSettings();
                }
            }
            return this.allSettings;
        }
    }
}

