/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.storage;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.storage.DictionaryFileStorage;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.AbstractFileStorageProvider;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.dictionary.DictionaryFormatFactory;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.model.ResourceStorageSettings;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;

public class DictionaryFileStorageProvider
extends AbstractFileStorageProvider {
    public static final String PROVIDER_ID = "dictionary";
    public static final String SEGMENT = "common";
    private final ITranslatingProjectManager translatingProjectManager;
    private final ITranslationStorageManager translationStorageManager;

    @Inject
    public DictionaryFileStorageProvider(ITranslatingProjectManager translatingProjectManager, IStorageSettingsManager storageSettingsManager, ITranslationStorageManager translationStorageManager) {
        super(storageSettingsManager);
        this.translatingProjectManager = translatingProjectManager;
        this.translationStorageManager = translationStorageManager;
    }

    @Override
    public String getProviderId() {
        return PROVIDER_ID;
    }

    @Override
    protected ITranslationStorageProvider.Storage createStorage(IProject project, String segment) {
        DictionaryStorageSettings settings = this.getSegmentSettings(project, segment);
        if (settings == null) {
            settings = new DictionaryStorageSettings(segment);
            settings.setFormat("dict");
        }
        if (!this.isValidSettings(settings)) {
            return null;
        }
        return new DictionaryFileStorage(project, settings.getStorageId(), settings, this.translatingProjectManager, this.storageSettingsManager, this.translationStorageManager);
    }

    @Override
    protected Collection<? extends ResourceStorageSettings> getProjectSettings(IProject project) {
        return this.storageSettingsManager.getSettingsOrDefault(project).getDictionarySettings();
    }

    private boolean isValidSettings(DictionaryStorageSettings settings) {
        if (!DictionaryFormatFactory.isFormatSupported(settings.getFormat())) {
            return false;
        }
        String path = settings.getFilePath();
        return !StringUtils.isBlank(path) && Path.isValidPosixPath((String)path);
    }

    private DictionaryStorageSettings getSegmentSettings(IProject project, String segment) {
        Collection<DictionaryStorageSettings> settingsList = this.storageSettingsManager.getSettingsOrDefault(project).getDictionarySettings();
        for (DictionaryStorageSettings settings : settingsList) {
            if (!segment.equalsIgnoreCase(settings.getId())) continue;
            return settings;
        }
        return null;
    }
}

