/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.storage;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.storage.Messages;
import com.e1c.langtool.storage.IProjectStorageSettingsConfigurator;
import com.e1c.langtool.storage.IStorageSettingsChangeListener;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.model.ProjectStorageSettings;
import com.e1c.langtool.storage.model.ResourceStorageSettings;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.Preferences;

@Singleton
public class StorageSettingsManager
implements IStorageSettingsManager {
    private static final String EXTENSION_POINT_ID = "translationStorageProvider";
    private static final String ELEMENT_SETTINGS_CONGIGURATOR = "settingsConfigurator";
    private static final String ATT_CLASS = "class";
    private static final String STORE_NODE_ID = "storage";
    private static final String STORAGE_ORDER_KEY = "order";
    private static final String STORAGE_DEFAULT_EDITING_KEY = "defaulEditing";
    private static final IPath SETTINGS_PATH = new Path(".settings/translation_storages.yml");
    @Inject
    private ITranslationStorageManager storageManager;
    private final Map<IProject, ProjectStorageSettings> settings = new ConcurrentHashMap<IProject, ProjectStorageSettings>();
    private final IResourceChangeListener projectChangelistener = new ProjectChangeListener();
    private final ListenerList<IStorageSettingsChangeListener> changeListeners = new ListenerList();
    private volatile Collection<IProjectStorageSettingsConfigurator> configurators;

    public void activate() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projectChangelistener);
    }

    public void deactivate() {
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.projectChangelistener);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public ProjectStorageSettings getSettingsOrDefault(IProject project) {
        AtomicBoolean needStartValidate = new AtomicBoolean();
        try {
            ProjectStorageSettings projectStorageSettings = this.settings.computeIfAbsent(project, p -> {
                ProjectStorageSettings storageSettings = null;
                IFile file = project.getFile(SETTINGS_PATH);
                if (file.isAccessible()) {
                    storageSettings = StorageSettingsUtils.loadStorageSettings(file);
                    needStartValidate.set(true);
                }
                if (storageSettings == null && !p.isAccessible()) {
                    return storageSettings;
                }
                if (storageSettings == null) {
                    storageSettings = this.createAndConfigureNewSettings((IProject)p);
                } else {
                    this.addContributedSettings((IProject)p, storageSettings, false);
                }
                return storageSettings;
            });
            if (projectStorageSettings == null) {
                projectStorageSettings = new ProjectStorageSettings();
            }
            ProjectStorageSettings projectStorageSettings2 = projectStorageSettings;
            return projectStorageSettings2;
        }
        finally {
            if (needStartValidate.get()) {
                IFile file = project.getFile(SETTINGS_PATH);
                this.startValidation(file);
            }
        }
    }

    @Override
    public void saveSettings(IProject project, ProjectStorageSettings settings, IProgressMonitor monitor) {
        IFile file = project.getFile(SETTINGS_PATH);
        StorageSettingsUtils.saveStorageSettings(settings, file, monitor);
    }

    @Override
    public List<StorageID> getReadStorageIds(IProject project) {
        return this.getSettingsOrDefault(project).getReadStorageIds();
    }

    @Override
    public void saveReadSettings(IProject project, List<StorageSettings> settings) {
        ProjectStorageSettings projectSettings = this.getSettingsOrDefault(project);
        ArrayList ids = Lists.newArrayList();
        StorageID editing = projectSettings.getEdit().getStorageId();
        for (StorageSettings setting : settings) {
            ids.add(setting.getStorageId());
            if (editing.equals(setting.getStorageId()) || setting instanceof ResourceStorageSettings || projectSettings.getStorages().containsKey(setting.getStorageId().toString())) continue;
            projectSettings.getStorages().put(setting.getStorageId().toString(), setting);
        }
        projectSettings.getRead().clear();
        projectSettings.getRead().addAll(ids);
        this.saveSettings(project, projectSettings, (IProgressMonitor)new NullProgressMonitor());
    }

    private List<StorageID> getOldSettingsOfStorageIds(IProject project) {
        String orderString;
        Preferences storageNode;
        ArrayList<StorageID> ids = new ArrayList<StorageID>();
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("com.e1c.langtool");
        if (projectNode != null && (storageNode = projectNode.node(STORE_NODE_ID)) != null && StringUtils.isNotEmpty(orderString = storageNode.get(STORAGE_ORDER_KEY, ""))) {
            String[] strings;
            String[] stringArray = strings = orderString.split(";");
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String fullId = stringArray[n2];
                try {
                    ids.add(StorageID.create(fullId));
                }
                catch (Exception e) {
                    CorePlugin.logError(e);
                }
                ++n2;
            }
        }
        return ids;
    }

    @Override
    public void saveReadStorageIds(IProject project, List<StorageID> ids) {
        ProjectStorageSettings projectSettings = this.getSettingsOrDefault(project);
        projectSettings.getRead().clear();
        projectSettings.getRead().addAll(ids);
        this.saveSettings(project, projectSettings, (IProgressMonitor)new NullProgressMonitor());
    }

    private StorageID getOldSettingsDefaultEditingStorageId(IProject project) {
        String defaultEditingString;
        Preferences storageNode;
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("com.e1c.langtool");
        if (projectNode != null && (storageNode = projectNode.node(STORE_NODE_ID)) != null && StringUtils.isNotEmpty(defaultEditingString = storageNode.get(STORAGE_DEFAULT_EDITING_KEY, ""))) {
            try {
                StorageID id = StorageID.create(defaultEditingString);
                return id;
            }
            catch (Exception e) {
                CorePlugin.logError(e);
            }
        }
        return null;
    }

    @Override
    public boolean isStorageAvailable(IProject project, StorageID storageId) {
        List<StorageID> availableStorageIds = this.getReadStorageIds(project);
        return availableStorageIds.contains(storageId);
    }

    @Override
    public void saveDefaultEditingStorageId(IProject project, StorageID id) {
        ProjectStorageSettings projectSettings = this.getSettingsOrDefault(project);
        if (!projectSettings.getEdit().getStorageId().equals(id)) {
            projectSettings.getEdit().getRules().clear();
            projectSettings.getEdit().getStorages().clear();
            projectSettings.getEdit().getStorages().add(id);
            this.saveSettings(project, projectSettings, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    public void addChangeListener(IStorageSettingsChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    @Override
    public void removeChangeListener(IStorageSettingsChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    protected void fireSettingsChanged(IProject project, boolean projectClosed) {
        if (project == null) {
            return;
        }
        for (IStorageSettingsChangeListener l : this.changeListeners) {
            try {
                SafeRunner.run(() -> l.settingsChanged(project, projectClosed));
            }
            catch (Throwable e) {
                CorePlugin.logError(e);
            }
        }
    }

    private ProjectStorageSettings createAndConfigureNewSettings(IProject project) {
        ProjectStorageSettings storageSettings = new ProjectStorageSettings();
        this.migrateOldSettings(project, storageSettings);
        boolean hasAvailable = !storageSettings.getRead().isEmpty();
        this.addContributedSettings(project, storageSettings, hasAvailable);
        for (IProjectStorageSettingsConfigurator configurator : this.getConfigurators()) {
            if (!configurator.canConfigure(project)) continue;
            configurator.configureNewSettings(project, storageSettings);
        }
        return storageSettings;
    }

    private void addContributedSettings(IProject project, ProjectStorageSettings storageSettings, boolean addDefaultEnabledToRead) {
        for (ITranslationStorageProvider provider : this.storageManager.allStorageProviders()) {
            String providerId = provider.getProviderId();
            if ("edit".equals(providerId) || "dictionary".equals(providerId) || "context".equals(providerId)) continue;
            List<String> segments = provider.getStorageSegments(project);
            for (String segment : segments) {
                StorageID id = new StorageID(providerId, segment);
                StorageSettings settings = new StorageSettings();
                settings.setId(id.toString());
                settings.setPresentation(provider.getStorageDescription(project, id.getSegment()));
                ITranslationStorageProvider.Storage storage = provider.getStorage(project, id.getSegment());
                if (storage != null) {
                    settings.setReadOnly(storage.isReadOnly());
                }
                if (!addDefaultEnabledToRead && this.storageManager.isDefaultEnable(id)) {
                    storageSettings.getRead().add(id);
                }
                storageSettings.addContributed(settings);
            }
        }
    }

    private void migrateOldSettings(IProject project, ProjectStorageSettings storageSettings) {
        StorageID editingId = this.getOldSettingsDefaultEditingStorageId(project);
        if (editingId != null) {
            storageSettings.getEdit().getStorages().add(editingId);
        }
        for (StorageID id : this.getOldSettingsOfStorageIds(project)) {
            storageSettings.getRead().add(id);
            StorageSettings setting = new StorageSettings();
            setting.setId(id.toString());
            ITranslationStorageProvider provider = this.storageManager.getStorageProvider(id);
            if (provider != null) {
                setting.setPresentation(provider.getStorageDescription(project, id.getSegment()));
                ITranslationStorageProvider.Storage storage = provider.getStorage(project, id.getSegment());
                if (storage != null) {
                    setting.setReadOnly(storage.isReadOnly());
                }
            }
            storageSettings.addStorages(setting);
        }
    }

    private void startValidation(IFile file) {
        Job validationJob = Job.create((String)Messages.StorageSettingsManager_validation_job_name, monitor -> StorageSettingsUtils.validateStorageSettings(file, monitor));
        validationJob.setRule((ISchedulingRule)file);
        validationJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<IProjectStorageSettingsConfigurator> getConfigurators() {
        if (this.configurators != null) return this.configurators;
        Class<StorageSettingsManager> clazz = StorageSettingsManager.class;
        synchronized (StorageSettingsManager.class) {
            if (this.configurators != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.configurators;
            }
            this.configurators = this.loadConfigurators();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.configurators;
        }
    }

    private Collection<IProjectStorageSettingsConfigurator> loadConfigurators() {
        ArrayList<IProjectStorageSettingsConfigurator> result = new ArrayList<IProjectStorageSettingsConfigurator>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool", EXTENSION_POINT_ID);
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement element = configElements[i];
            if (ELEMENT_SETTINGS_CONGIGURATOR.equals(element.getName())) {
                try {
                    IProjectStorageSettingsConfigurator configurator = (IProjectStorageSettingsConfigurator)element.createExecutableExtension(ATT_CLASS);
                    result.add(configurator);
                }
                catch (CoreException e) {
                    CorePlugin.logError(e);
                }
            }
            ++i;
        }
        return List.copyOf(result);
    }

    private class ProjectChangeListener
    implements IResourceChangeListener {
        private ProjectChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta;
            IResource res = event.getResource();
            if ((event.getType() == 2 || event.getType() == 4) && res instanceof IProject) {
                ProjectStorageSettings removed = StorageSettingsManager.this.settings.remove(res);
                if (removed != null) {
                    StorageSettingsManager.this.fireSettingsChanged((IProject)res, true);
                }
            } else if (event.getType() == 1 && (delta = event.getDelta()) != null && (delta.getKind() == 4 || delta.getKind() == 2 || delta.getKind() == 1)) {
                Iterator<Map.Entry<IProject, ProjectStorageSettings>> iterator = StorageSettingsManager.this.settings.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<IProject, ProjectStorageSettings> entry = iterator.next();
                    IProject project = entry.getKey();
                    IPath path = project.getFullPath().append(SETTINGS_PATH);
                    IResourceDelta changed = delta.findMember(path);
                    if (changed == null || (changed.getKind() != 4 || (changed.getFlags() & 0x100) == 0) && changed.getKind() != 1 && changed.getKind() != 2) continue;
                    iterator.remove();
                    StorageSettingsManager.this.fireSettingsChanged(project, false);
                }
            }
        }
    }
}

