/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.storage;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.storage.Messages;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.model.ProjectStorageSettings;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

@Singleton
public class UniqueTranslationValidator
implements FeatureValueValidator {
    @Inject
    private IStorageSettingsManager storageSettingsManager;

    @Override
    public IStatus isValid(String value, FeatureValueValidator.ValidationContext context) {
        ITranslationStorageProvider.DictionaryStorage dict;
        ITranslationStorageProvider.ContextStorage contextStorage;
        if (!context.getTranslationKey().getFeatureSettings().isUnique() || StringUtils.isNullOrEmpty(value)) {
            return Status.OK_STATUS;
        }
        ITranslationStorageProvider.Storage storage = context.getStorage();
        boolean shouldCheckValueUnique = true;
        ProjectStorageSettings projectSettings = this.storageSettingsManager.getSettingsOrDefault(context.getProject());
        StorageSettings settings = projectSettings.allStorageSettings().get(storage.getId());
        if (settings != null) {
            shouldCheckValueUnique = StorageSettingsUtils.getBooleanSettings(settings, "value_unique", true);
        }
        if (!shouldCheckValueUnique) {
            return Status.OK_STATUS;
        }
        if (storage instanceof ITranslationStorageProvider.ContextStorage && context.getTranslationKey() instanceof ContextTranslationKey ? (contextStorage = (ITranslationStorageProvider.ContextStorage)storage).hasKeyForValue(value, context.getLanguage(), (ContextTranslationKey)context.getTranslationKey()) : storage instanceof ITranslationStorageProvider.DictionaryStorage && (dict = (ITranslationStorageProvider.DictionaryStorage)storage).hasKeyForValue(value, context.getLanguage(), context.getTranslationKey())) {
            return CorePlugin.createErrorStatus(Messages.UniqueTranslationValidator_Translation_value_for_model_feature_is_not_unique, null);
        }
        return Status.OK_STATUS;
    }
}

