/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.query;

import com.e1c.langtool.query.IMultiTranslationQuery;
import com.e1c.langtool.query.TranslationQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MultiTranslationQuery
extends TranslationQuery
implements IMultiTranslationQuery {
    private final List<String> texts;

    public static IMultiTranslationQuery createQuery(List<String> texts, String source, String target, boolean isProcessing) {
        return new MultiTranslationQuery(texts, source, target, isProcessing);
    }

    public static IMultiTranslationQuery createQuery(List<String> texts, String source, String target) {
        return new MultiTranslationQuery(texts, source, target, true);
    }

    private MultiTranslationQuery(List<String> texts, String source, String target, boolean isProcessing) {
        super(source, target, isProcessing);
        this.texts = Collections.unmodifiableList(new ArrayList<String>(texts));
    }

    @Override
    public List<String> getTexts() {
        return this.texts;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.texts == null ? 0 : this.texts.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiTranslationQuery other = (MultiTranslationQuery)obj;
        return !(this.texts == null ? other.texts != null : !this.texts.equals(other.texts));
    }
}

