/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.settings;

import com.e1c.langtool.settings.FeatureSettings;
import java.util.Objects;

public final class CommonFeatureSettings
implements FeatureSettings {
    private static final long serialVersionUID = -340123162181298398L;
    private final String name;
    private final boolean isId;
    private final boolean isUnique;
    private final boolean isInterface;
    private final String presentation;
    private final boolean isCamelCase;
    private final boolean isMultiLine;
    private final boolean isPreferContext;
    private final int hashCode;
    private final boolean isTag;

    public CommonFeatureSettings(String name, boolean isId, boolean isInterface, String presentation, boolean isCamelCase, boolean isMultiLine, boolean isPreferContext, boolean isTag) {
        this.name = name;
        this.isId = isId;
        this.isInterface = isInterface;
        this.presentation = presentation;
        this.isUnique = isId;
        this.isCamelCase = isCamelCase;
        this.isMultiLine = isMultiLine;
        this.isPreferContext = isPreferContext;
        this.isTag = isTag;
        this.hashCode = Objects.hash(isCamelCase, isId, isInterface, isMultiLine, isPreferContext, this.isUnique, name, presentation);
    }

    public CommonFeatureSettings(String name, boolean isId, boolean isInterface, String presentation, boolean isUnique, boolean isCamelCase, boolean isMultiLine, boolean isPreferContext, boolean isTag) {
        this.name = name;
        this.isId = isId;
        this.isInterface = isInterface;
        this.presentation = presentation;
        this.isUnique = isUnique;
        this.isCamelCase = isCamelCase;
        this.isMultiLine = isMultiLine;
        this.isPreferContext = isPreferContext;
        this.isTag = isTag;
        this.hashCode = Objects.hash(isCamelCase, isId, isInterface, isMultiLine, isPreferContext, isUnique, name, presentation, isTag);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isId() {
        return this.isId;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public String getPresentation() {
        if (this.presentation == null) {
            return this.getName();
        }
        return this.presentation;
    }

    @Override
    public boolean isCamelCase() {
        return this.isCamelCase;
    }

    @Override
    public boolean isMultiLine() {
        return this.isMultiLine;
    }

    @Override
    public boolean isPreferContext() {
        return this.isPreferContext;
    }

    @Override
    public boolean isTag() {
        return this.isTag;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommonFeatureSettings other = (CommonFeatureSettings)obj;
        return this.isCamelCase == other.isCamelCase && this.isId == other.isId && this.isInterface == other.isInterface && this.isMultiLine == other.isMultiLine && this.isPreferContext == other.isPreferContext && this.isUnique == other.isUnique && Objects.equals(this.name, other.name) && Objects.equals(this.presentation, other.presentation);
    }

    public static final class Builder {
        private String feature;
        private boolean isId;
        private boolean isInterface;
        private boolean isModel = true;
        private boolean isUnique;
        private boolean isCamelCase;
        private boolean isMultiLine;
        private boolean isPreferContext;
        private boolean isTag;
        private String presentation;

        public CommonFeatureSettings build() {
            return new CommonFeatureSettings(this.feature, this.isId, this.isInterface, this.presentation, this.isUnique, this.isCamelCase, this.isMultiLine, this.isPreferContext, this.isTag);
        }

        public Builder setFeature(String featureName) {
            this.feature = featureName;
            if (this.presentation == null) {
                this.presentation = featureName;
            }
            return this;
        }

        public Builder setPresentation(String presentation) {
            this.presentation = presentation;
            return this;
        }

        public Builder setId() {
            this.isId = true;
            this.isUnique = true;
            return this;
        }

        public Builder setInterface() {
            this.isInterface = true;
            this.isModel = !this.isInterface;
            this.setPreferContext();
            return this;
        }

        public Builder setModel() {
            this.isModel = true;
            this.isInterface = !this.isModel;
            return this;
        }

        public Builder setUnique() {
            this.isUnique = true;
            return this;
        }

        public Builder setCamelCase() {
            this.isCamelCase = true;
            return this;
        }

        public Builder setMultiLine() {
            this.isMultiLine = true;
            return this;
        }

        public Builder setPreferContext() {
            this.isPreferContext = true;
            return this;
        }

        public Builder setTag() {
            this.isTag = true;
            return this;
        }
    }
}

