/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage;

import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.storage.CachedFileMediator;
import com.e1c.langtool.storage.IStorageValueChangedListener;
import com.e1c.langtool.storage.ITranslationFileEditorFactory;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.StorageValueChangeEvent;
import com.e1c.langtool.storage.model.StorageSettings;
import com.google.inject.Provider;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;

public abstract class AbstractFileStorage
implements ITranslationStorageProvider.Storage {
    protected final CachedFileMediator fileMediator;
    private final ListenerList<IStorageValueChangedListener> valueChangedListeners = new ListenerList();
    protected final IProject project;
    protected final StorageID id;
    private final StorageSettings settings;
    protected AtomicBoolean batchUpdate = new AtomicBoolean();

    public AbstractFileStorage(IProject project, StorageID id, StorageSettings settings) {
        this.project = project;
        this.id = id;
        this.settings = settings;
        this.fileMediator = new CachedFileMediator(this.getTranslationFileEditorFactory(settings));
    }

    @Override
    public StorageID getId() {
        return this.id;
    }

    @Override
    public String getSegment() {
        return this.getId().getSegment();
    }

    @Override
    public boolean isReadOnly() {
        return this.settings.isReadOnly();
    }

    @Override
    public void addValueChangedListener(IStorageValueChangedListener listener) {
        this.valueChangedListeners.add((Object)listener);
    }

    @Override
    public void removeValueChangedListener(IStorageValueChangedListener listener) {
        this.valueChangedListeners.remove((Object)listener);
    }

    @Override
    public void beginBatchUpdate() {
        this.fileMediator.beginBatchUpdate();
        this.batchUpdate.set(true);
    }

    @Override
    public void endBatchUpdate() {
        this.fileMediator.endBatchUpdate();
        this.batchUpdate.set(false);
    }

    public void dispose() {
        this.batchUpdate.set(false);
        this.fileMediator.dispose();
        this.valueChangedListeners.clear();
    }

    protected void firePostValueChanged(StorageValueChangeEvent event) {
        if (this.batchUpdate.get()) {
            return;
        }
        for (IStorageValueChangedListener l : this.valueChangedListeners) {
            try {
                SafeRunner.run(() -> l.changed(event));
            }
            catch (Throwable e) {
                CorePlugin.logError(e);
            }
        }
    }

    protected abstract Provider<ITranslationFileEditorFactory<?>> getTranslationFileEditorFactory(StorageSettings var1);
}

