/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage;

import com.e1c.langtool.common.Pair;
import com.e1c.langtool.storage.AbstractFileStorage;
import com.e1c.langtool.storage.IStorageSettingsChangeListener;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.model.ResourceStorageSettings;
import com.e1c.langtool.storage.model.StorageSettings;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;

public abstract class AbstractFileStorageProvider
implements ITranslationStorageProvider {
    protected final IStorageSettingsManager storageSettingsManager;
    private final Map<Pair<IProject, String>, ITranslationStorageProvider.Storage> storageSegments = Maps.newConcurrentMap();
    private final IStorageSettingsChangeListener settingsChangeListener = this::settingsChanged;

    public AbstractFileStorageProvider(IStorageSettingsManager storageSettingsManager) {
        this.storageSettingsManager = storageSettingsManager;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void initialize(IProject project, List<String> segments) {
        this.storageSettingsManager.addChangeListener(this.settingsChangeListener);
    }

    @Override
    public List<String> getStorageSegments(IProject project) {
        Collection<? extends ResourceStorageSettings> settings = this.getProjectSettings(project);
        if (settings == null) {
            return List.of();
        }
        return settings.stream().map(StorageSettings::getId).collect(Collectors.toList());
    }

    @Override
    public String getStorageDescription(IProject project, String segment) {
        Collection<? extends ResourceStorageSettings> settings = this.getProjectSettings(project);
        if (settings == null) {
            return segment;
        }
        return settings.stream().filter(s -> segment.equalsIgnoreCase(s.getId())).map(StorageSettings::getPresentation).findFirst().orElse(segment);
    }

    @Override
    public ITranslationStorageProvider.Storage getStorage(IProject project, String segment) {
        Assert.isNotNull((Object)project);
        Assert.isNotNull((Object)segment);
        Pair<IProject, String> key = new Pair<IProject, String>(project, segment);
        return this.storageSegments.computeIfAbsent(key, k -> {
            this.storageSettingsManager.addChangeListener(this.settingsChangeListener);
            return this.createStorage((IProject)k.getKey(), (String)k.getValue());
        });
    }

    protected void settingsChanged(IProject project, boolean projectClosed) {
        Iterator<Map.Entry<Pair<IProject, String>, ITranslationStorageProvider.Storage>> iterator = this.storageSegments.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Pair<IProject, String>, ITranslationStorageProvider.Storage> entry = iterator.next();
            if (!project.equals((Object)entry.getKey().getKey())) continue;
            iterator.remove();
            this.disposeStorage(entry.getKey().getKey(), entry.getKey().getValue(), entry.getValue());
        }
        if (this.storageSegments.isEmpty()) {
            this.storageSettingsManager.removeChangeListener(this.settingsChangeListener);
        }
    }

    protected abstract ITranslationStorageProvider.Storage createStorage(IProject var1, String var2);

    protected void disposeStorage(IProject project, String segment, ITranslationStorageProvider.Storage storage) {
        if (storage instanceof AbstractFileStorage) {
            ((AbstractFileStorage)storage).dispose();
        }
    }

    protected abstract Collection<? extends ResourceStorageSettings> getProjectSettings(IProject var1);
}

