/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IEditingContext;
import com.e1c.langtool.storage.IEditingContextListener;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;

public class GlobalEditingContext
implements IEditingContext {
    private final ListenerList<IEditingContextListener> listeners = new ListenerList();
    private final IProject project;
    private final ITranslationStorageManager translationStorageManager;

    public GlobalEditingContext(IProject project, ITranslationStorageManager translationStorageManager) {
        this.project = project;
        this.translationStorageManager = translationStorageManager;
    }

    @Override
    public String getTranslation(StorageID storageId, TranslationKey translationKey, TranslateLanguage language) {
        ITranslationStorageProvider.Storage storage = this.translationStorageManager.getStorage(this.project, storageId);
        if (storage instanceof ITranslationStorageProvider.ContextStorage && translationKey instanceof ContextTranslationKey) {
            return ((ITranslationStorageProvider.ContextStorage)storage).getTranslation((ContextTranslationKey)translationKey, language);
        }
        if (storage instanceof ITranslationStorageProvider.DictionaryStorage) {
            return ((ITranslationStorageProvider.DictionaryStorage)storage).getTranslation(translationKey, language);
        }
        return null;
    }

    @Override
    public void setTranslation(StorageID storageId, TranslationKey translationKey, TranslateLanguage language, String translation) {
        ITranslationStorageProvider.Storage storage = this.translationStorageManager.getStorage(this.project, storageId);
        if (storage != null && storage.isReadOnly()) {
            return;
        }
        if (storage instanceof ITranslationStorageProvider.ContextStorage && translationKey instanceof ContextTranslationKey) {
            ((ITranslationStorageProvider.ContextStorage)storage).setTranslation((ContextTranslationKey)translationKey, language, translation, true);
        } else if (storage instanceof ITranslationStorageProvider.DictionaryStorage) {
            ((ITranslationStorageProvider.DictionaryStorage)storage).setTranslation(translationKey, language, translation, true);
        }
        for (IEditingContextListener l : this.listeners) {
            try {
                SafeRunner.run(l::contextChanged);
            }
            catch (Throwable e) {
                CorePlugin.logError(e);
            }
        }
    }

    @Override
    public void removeTranslation(StorageID storageId, TranslationKey translationKey, TranslateLanguage language) {
        ITranslationStorageProvider.Storage storage = this.translationStorageManager.getStorage(this.project, storageId);
        if (storage != null && storage.isReadOnly()) {
            return;
        }
        if (storage instanceof ITranslationStorageProvider.ContextStorage && translationKey instanceof ContextTranslationKey) {
            ((ITranslationStorageProvider.ContextStorage)storage).removeTranslation((ContextTranslationKey)translationKey, language, true);
        } else if (storage instanceof ITranslationStorageProvider.DictionaryStorage) {
            ((ITranslationStorageProvider.DictionaryStorage)storage).removeTranslation(translationKey, language, true);
        }
        for (IEditingContextListener l : this.listeners) {
            try {
                SafeRunner.run(l::contextChanged);
            }
            catch (Throwable e) {
                CorePlugin.logError(e);
            }
        }
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void save() {
        for (IEditingContextListener l : this.listeners) {
            try {
                SafeRunner.run(l::contextSaved);
            }
            catch (Throwable e) {
                CorePlugin.logError(e);
            }
        }
    }

    @Override
    public IUndoContext getUndoContext() {
        return IOperationHistory.GLOBAL_UNDO_CONTEXT;
    }

    @Override
    public void dispose() {
        for (IEditingContextListener l : this.listeners) {
            try {
                SafeRunner.run(l::contextDisposed);
            }
            catch (Throwable e) {
                CorePlugin.logError(e);
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public void addListener(IEditingContextListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IEditingContextListener listener) {
        this.listeners.remove((Object)listener);
    }
}

