/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageValueChangedListener;
import com.e1c.langtool.storage.StorageID;
import com.google.common.hash.HashFunction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public interface ITranslationStorageProvider {
    public String getProviderId();

    public boolean isActive();

    public void initialize(IProject var1, List<String> var2);

    public List<String> getStorageSegments(IProject var1);

    public String getStorageDescription(IProject var1, String var2);

    public Storage getStorage(IProject var1, String var2);

    public static interface ContextStorage
    extends Storage {
        @Override
        default public Storage.Type getType() {
            return Storage.Type.CONTEXT;
        }

        @Override
        default public String getTranslation(FeatureValue source, TranslateLanguage language) {
            return this.getTranslation(source.getContextKey(), language);
        }

        @Override
        default public void setTranslation(FeatureValue source, TranslateLanguage language, String translation, boolean autoSave) {
            this.setTranslation(source.getContextKey(), language, translation, autoSave);
            this.setComment(source.getContextKey(), language, source.getComment(), autoSave);
        }

        @Override
        default public void removeTranslation(FeatureValue source, TranslateLanguage language, boolean autoSave) {
            this.removeTranslation(source.getContextKey(), language, autoSave);
            this.removeComment(source.getContextKey(), language, autoSave);
        }

        @Override
        default public void moveTranslation(FeatureValue fromSource, FeatureValue toSource, TranslateLanguage language, boolean autoSave) {
            this.moveTranslation(fromSource.getContextKey(), toSource.getContextKey(), language, autoSave);
            this.moveComment(fromSource.getContextKey(), toSource.getContextKey(), language, autoSave);
        }

        public String getTranslation(ContextTranslationKey var1, TranslateLanguage var2);

        public void setTranslation(ContextTranslationKey var1, TranslateLanguage var2, String var3, boolean var4);

        public void removeTranslation(ContextTranslationKey var1, TranslateLanguage var2, boolean var3);

        public Map<IFile, byte[]> saveFiles(Collection<ContextTranslationKey> var1, TranslateLanguage var2, HashFunction var3);

        public void moveTranslation(ContextTranslationKey var1, ContextTranslationKey var2, TranslateLanguage var3, boolean var4);

        default public String getComment(ContextTranslationKey key, TranslateLanguage language) {
            return null;
        }

        default public void setComment(ContextTranslationKey key, TranslateLanguage language, String comment, boolean autoSave) {
        }

        default public void removeComment(ContextTranslationKey key, TranslateLanguage language, boolean autoSave) {
        }

        default public void moveComment(ContextTranslationKey fromKey, ContextTranslationKey toKey, TranslateLanguage language, boolean autoSave) {
        }

        public boolean hasKeyForValue(String var1, TranslateLanguage var2, ContextTranslationKey var3);
    }

    public static interface DictionaryStorage
    extends Storage {
        @Override
        default public Storage.Type getType() {
            return Storage.Type.COMMON;
        }

        @Override
        default public String getTranslation(FeatureValue source, TranslateLanguage language) {
            return this.getTranslation(source.getContextKey(), language);
        }

        @Override
        default public void setTranslation(FeatureValue source, TranslateLanguage language, String translation, boolean autoSave) {
            this.setTranslation(source.getContextKey(), language, translation, autoSave);
            this.setComment(source.getContextKey(), language, source.getComment(), autoSave);
        }

        @Override
        default public void removeTranslation(FeatureValue source, TranslateLanguage language, boolean autoSave) {
            this.removeTranslation(source.getContextKey(), language, autoSave);
            this.removeComment(source.getContextKey(), language, autoSave);
        }

        @Override
        default public void moveTranslation(FeatureValue fromSource, FeatureValue toSource, TranslateLanguage language, boolean autoSave) {
            this.moveTranslation(fromSource.getContextKey(), toSource.getContextKey(), language, autoSave);
            this.moveComment(fromSource.getContextKey(), toSource.getContextKey(), language, autoSave);
        }

        public String getTranslation(TranslationKey var1, TranslateLanguage var2);

        public void setTranslation(TranslationKey var1, TranslateLanguage var2, String var3, boolean var4);

        public Map<IFile, byte[]> saveFiles(TranslateLanguage var1, HashFunction var2);

        public void removeTranslation(TranslationKey var1, TranslateLanguage var2, boolean var3);

        public void moveTranslation(TranslationKey var1, TranslationKey var2, TranslateLanguage var3, boolean var4);

        default public String getComment(TranslationKey key, TranslateLanguage language) {
            return null;
        }

        default public void setComment(TranslationKey key, TranslateLanguage language, String comment, boolean autoSave) {
        }

        default public void removeComment(TranslationKey key, TranslateLanguage language, boolean autoSave) {
        }

        default public void moveComment(TranslationKey fromKey, TranslationKey toKey, TranslateLanguage language, boolean autoSave) {
        }

        public boolean hasKeyForValue(String var1, TranslateLanguage var2, TranslationKey var3);
    }

    public static interface Storage {
        public StorageID getId();

        public String getSegment();

        public void addValueChangedListener(IStorageValueChangedListener var1);

        public void removeValueChangedListener(IStorageValueChangedListener var1);

        public String getTranslation(FeatureValue var1, TranslateLanguage var2);

        public void setTranslation(FeatureValue var1, TranslateLanguage var2, String var3, boolean var4);

        public void removeTranslation(FeatureValue var1, TranslateLanguage var2, boolean var3);

        public void moveTranslation(FeatureValue var1, FeatureValue var2, TranslateLanguage var3, boolean var4);

        public Type getType();

        public void beginBatchUpdate();

        public void endBatchUpdate();

        default public boolean isReadOnly() {
            return false;
        }

        public static enum Type {
            CONTEXT,
            COMMON;

        }
    }
}

