/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage;

import org.eclipse.core.runtime.Assert;

public class StorageID
implements Comparable<StorageID> {
    private static final String DELIMITER = ":";
    private final String providerId;
    private final String segment;
    private final int hashCode;

    public static StorageID create(String fullId) {
        Assert.isNotNull((Object)fullId, (String)"Full id cannot be null");
        String[] strings = fullId.split(DELIMITER);
        StorageID id = new StorageID(strings[0], strings[1]);
        return id;
    }

    public StorageID(String providerId, String segment) {
        Assert.isNotNull((Object)providerId, (String)"Provider id cannot be null");
        Assert.isNotNull((Object)segment, (String)"Segment cannot be null");
        this.providerId = providerId;
        this.segment = segment;
        this.hashCode = this.getHashCode();
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getSegment() {
        return this.segment;
    }

    public String toString() {
        return String.join((CharSequence)DELIMITER, this.providerId, this.segment);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageID)) {
            return false;
        }
        StorageID other = (StorageID)obj;
        if (this.providerId == null ? other.providerId != null : !this.providerId.equals(other.providerId)) {
            return false;
        }
        return !(this.segment == null ? other.segment != null : !this.segment.equals(other.segment));
    }

    private int getHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.providerId == null ? 0 : this.providerId.hashCode());
        result = 31 * result + (this.segment == null ? 0 : this.segment.hashCode());
        return result;
    }

    @Override
    public int compareTo(StorageID o) {
        int result = this.providerId.compareTo(o.providerId);
        if (result == 0) {
            result = this.segment.compareTo(o.segment);
        }
        return result;
    }
}

