/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.context;

import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IFileEditor;
import com.e1c.langtool.storage.ITranslationFileEditorFactory;
import com.e1c.langtool.storage.context.ContextTranslationData;
import com.e1c.langtool.storage.model.ContextStorageSettings;
import com.e1c.langtool.storage.properties.PropertiesContextFileEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class ContextFormatFactory
implements ITranslationFileEditorFactory<ContextTranslationData> {
    public static final String FORMAT_PROPERTIES = "properties";
    public static final String FORMAT_REGEX = "cotext-regex";
    public static final String FORMAT_PO = "po";
    private final ContextStorageSettings settings;

    public static IFileEditor<? extends ContextTranslationData> createEditor(IFile file, IProject project, ContextStorageSettings settings, TranslateLanguage language) {
        switch (settings.getFormat()) {
            case "properties": {
                return new PropertiesContextFileEditor(file, project, settings, language);
            }
            case "cotext-regex": {
                return null;
            }
            case "po": {
                return null;
            }
        }
        return null;
    }

    public static boolean isFormatSupported(String format) {
        switch (format) {
            case "properties": {
                return true;
            }
        }
        return false;
    }

    public ContextFormatFactory(ContextStorageSettings settings) {
        this.settings = settings;
    }

    @Override
    public IFileEditor<ContextTranslationData> getFileEditor(IFile file, IProject project, TranslateLanguage language) {
        return ContextFormatFactory.createEditor(file, project, this.settings, language);
    }
}

