/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.dictionary;

import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IFileEditor;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationFileEditorFactory;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.dictionary.DictionaryData;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.properties.PropertiesDictionaryFileEditor;
import com.e1c.langtool.storage.regex.RegExDictionaryFileEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class DictionaryFormatFactory
implements ITranslationFileEditorFactory<DictionaryData> {
    public static final String FORMAT_DICT = "dict";
    public static final String FORMAT_REGEX = "dict-regex";
    public static final String FORMAT_PO = "po";
    private final ITranslatingProjectManager translatingProjectManager;
    private final IStorageSettingsManager storageSettingsManager;
    private final ITranslationStorageManager translationStorageManager;
    private final DictionaryStorageSettings settings;

    public DictionaryFormatFactory(DictionaryStorageSettings settings, ITranslatingProjectManager translatingProjectManager, IStorageSettingsManager storageSettingsManager, ITranslationStorageManager translationStorageManager) {
        this.settings = settings;
        this.translatingProjectManager = translatingProjectManager;
        this.storageSettingsManager = storageSettingsManager;
        this.translationStorageManager = translationStorageManager;
    }

    public IFileEditor<? extends DictionaryData> createEditor(IFile file, IProject project, DictionaryStorageSettings settings, TranslateLanguage language) {
        switch (settings.getFormat()) {
            case "dict": {
                return new PropertiesDictionaryFileEditor(file, project, settings, language, this.translatingProjectManager, this.storageSettingsManager, this.translationStorageManager);
            }
            case "dict-regex": {
                return new RegExDictionaryFileEditor(file, project, settings, language, this.translatingProjectManager, this.storageSettingsManager, this.translationStorageManager);
            }
            case "po": {
                return null;
            }
        }
        return null;
    }

    public static boolean isFormatSupported(String format) {
        if (format == null) {
            return false;
        }
        switch (format) {
            case "dict-regex": 
            case "dict": {
                return true;
            }
        }
        return false;
    }

    @Override
    public IFileEditor<DictionaryData> getFileEditor(IFile file, IProject project, TranslateLanguage language) {
        return this.createEditor(file, project, this.settings, language);
    }
}

