/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.model;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.model.ResourceStorageSettings;
import java.util.List;

public final class DictionaryStorageSettings
extends ResourceStorageSettings {
    private String filePath;
    private List<String> validation;

    public DictionaryStorageSettings(String segment) {
        this.setId(segment);
    }

    public DictionaryStorageSettings() {
    }

    @Override
    public StorageID getStorageId() {
        if (this.storageId == null) {
            this.storageId = new StorageID("dictionary", this.getId());
        }
        return this.storageId;
    }

    @Override
    public String getFormat() {
        String result = super.getFormat();
        if (StringUtils.isNullOrEmpty(result)) {
            result = "dict";
        }
        return result;
    }

    public String getFilePath() {
        if (this.filePath == null || this.filePath.isBlank()) {
            return this.getId();
        }
        return this.filePath;
    }

    public synchronized void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public List<String> getValidation() {
        if (this.validation == null) {
            return List.of();
        }
        return this.validation;
    }

    public synchronized void setValidation(List<String> validation) {
        this.validation = validation;
    }
}

