/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.model;

import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.model.ContextStorageSettings;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.model.EditSettings;
import com.e1c.langtool.storage.model.StorageIdList;
import com.e1c.langtool.storage.model.StorageSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ProjectStorageSettings {
    private final List<StorageSettings> contributed = new ArrayList<StorageSettings>();
    private EditSettings edit;
    private StorageIdList read;
    private Map<String, ContextStorageSettings> context;
    private Map<String, DictionaryStorageSettings> dictionary;
    private Map<String, StorageSettings> storages;
    private List<StorageSettings> readStorageSettings;
    private volatile Map<StorageID, StorageSettings> allStorageSettings;

    public EditSettings getEdit() {
        if (this.edit == null) {
            this.setEdit(new EditSettings());
        }
        return this.edit;
    }

    public synchronized void setEdit(EditSettings edit) {
        this.edit = edit;
    }

    public StorageIdList getRead() {
        if (this.read == null) {
            this.setRead(new StorageIdList());
        }
        return this.read;
    }

    public synchronized void setRead(StorageIdList read) {
        this.read = read;
    }

    public List<StorageID> getReadStorageIds() {
        return this.getRead().getStorageIds();
    }

    public Map<String, ContextStorageSettings> getContext() {
        if (this.context == null) {
            this.setContext(new ArrayList<ContextStorageSettings>());
        }
        return this.context;
    }

    public Collection<ContextStorageSettings> getContextSettings() {
        if (this.context == null) {
            this.setContext(new ArrayList<ContextStorageSettings>());
        }
        return this.context.values();
    }

    public synchronized void setContext(List<ContextStorageSettings> context) {
        this.context = new LinkedHashMap<String, ContextStorageSettings>();
        context.forEach(e -> {
            ContextStorageSettings contextStorageSettings = this.context.put(e.getId(), (ContextStorageSettings)e);
        });
        this.allStorageSettings = null;
    }

    public synchronized void setContext(Map<String, ContextStorageSettings> context) {
        this.context = context;
        if (this.context != null) {
            this.context.forEach((k, v) -> v.setId((String)k));
        }
        this.allStorageSettings = null;
    }

    public synchronized void addContext(ContextStorageSettings context) {
        this.getContext().put(context.getId(), context);
        this.allStorageSettings = null;
    }

    public Map<String, DictionaryStorageSettings> getDictionary() {
        if (this.dictionary == null) {
            this.setDictionary(new ArrayList<DictionaryStorageSettings>());
        }
        return this.dictionary;
    }

    public Collection<DictionaryStorageSettings> getDictionarySettings() {
        if (this.dictionary == null) {
            this.setDictionary(new ArrayList<DictionaryStorageSettings>());
        }
        return this.dictionary.values();
    }

    public synchronized void setDictionary(List<DictionaryStorageSettings> dictionary) {
        this.dictionary = new LinkedHashMap<String, DictionaryStorageSettings>();
        dictionary.forEach(e -> {
            DictionaryStorageSettings dictionaryStorageSettings = this.dictionary.put(e.getId(), (DictionaryStorageSettings)e);
        });
        this.allStorageSettings = null;
    }

    public synchronized void setDictionary(Map<String, DictionaryStorageSettings> dictionary) {
        this.dictionary = dictionary;
        if (this.dictionary != null) {
            this.dictionary.forEach((k, v) -> v.setId((String)k));
        }
        this.allStorageSettings = null;
    }

    public synchronized void addDictionary(DictionaryStorageSettings dictionary) {
        this.getDictionary().put(dictionary.getId(), dictionary);
        this.allStorageSettings = null;
    }

    public Map<String, StorageSettings> getStorages() {
        if (this.storages == null) {
            this.setStorages(new ArrayList<StorageSettings>());
        }
        return this.storages;
    }

    public Collection<StorageSettings> getStorageSettings() {
        if (this.storages == null) {
            this.setStorages(new ArrayList<StorageSettings>());
        }
        return this.storages.values();
    }

    public synchronized void setStorages(List<StorageSettings> storages) {
        this.storages = new LinkedHashMap<String, StorageSettings>();
        storages.forEach(e -> {
            StorageSettings storageSettings = this.storages.put(e.getId(), (StorageSettings)e);
        });
        this.allStorageSettings = null;
    }

    public synchronized void setStorages(Map<String, StorageSettings> storages) {
        this.storages = storages;
        if (this.storages != null) {
            this.storages.forEach((k, v) -> v.setId((String)k));
        }
        this.allStorageSettings = null;
    }

    public synchronized void addStorages(StorageSettings storages) {
        this.getStorages().put(storages.getId(), storages);
        this.allStorageSettings = null;
    }

    public List<StorageSettings> getReadStorageSettings() {
        if (this.readStorageSettings == null) {
            ArrayList<StorageSettings> settings = new ArrayList<StorageSettings>();
            for (StorageID id : this.getReadStorageIds()) {
                StorageSettings storageSettings = this.allStorageSettings().get(id);
                if (storageSettings == null) continue;
                settings.add(storageSettings);
            }
            this.readStorageSettings = List.copyOf(settings);
        }
        return this.readStorageSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<StorageID, StorageSettings> allStorageSettings() {
        if (this.allStorageSettings == null) {
            ProjectStorageSettings projectStorageSettings = this;
            synchronized (projectStorageSettings) {
                if (this.allStorageSettings != null) {
                    return this.allStorageSettings;
                }
                HashMap<StorageID, EditSettings> all = new HashMap<StorageID, EditSettings>();
                if (this.edit != null) {
                    all.put(this.edit.getStorageId(), this.edit);
                }
                this.getContextSettings().forEach(e -> {
                    StorageSettings storageSettings = all.computeIfAbsent(e.getStorageId(), k -> e);
                });
                this.getDictionarySettings().forEach(e -> {
                    StorageSettings storageSettings = all.computeIfAbsent(e.getStorageId(), k -> e);
                });
                this.getStorageSettings().forEach(e -> {
                    StorageSettings storageSettings = all.computeIfAbsent(e.getStorageId(), k -> e);
                });
                this.getContributed().forEach(e -> {
                    StorageSettings storageSettings = all.computeIfAbsent(e.getStorageId(), k -> e);
                });
                this.allStorageSettings = Map.copyOf(all);
            }
        }
        return this.allStorageSettings;
    }

    public List<StorageSettings> getContributed() {
        return this.contributed;
    }

    public synchronized void addContributed(StorageSettings settings) {
        this.getContributed().add(settings);
        this.allStorageSettings = null;
    }
}

