/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.properties;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.storage.context.ContextTranslationData;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class FeatureKeyContextData
implements ContextTranslationData {
    protected final boolean keyCaseSensitive;
    protected final boolean valueCaseSensitive;
    private String comment;
    protected final Map<FeatureKey, String> storage;
    protected final Map<FeatureKey, String> comments;
    private final Runnable changeNotification;

    public FeatureKeyContextData(boolean keyCaseSensitive, boolean valueCaseSensitive, String comment) {
        this(keyCaseSensitive, valueCaseSensitive, comment, null);
    }

    public FeatureKeyContextData(boolean keyCaseSensitive, boolean valueCaseSensitive, String comment, Runnable changeNotification) {
        this.keyCaseSensitive = keyCaseSensitive;
        this.valueCaseSensitive = valueCaseSensitive;
        this.setComment(comment);
        if (!this.keyCaseSensitive) {
            Comparator comparator = (o1, o2) -> o1.compareToIgnoreCase((FeatureKey)o2);
            this.storage = new ConcurrentSkipListMap<FeatureKey, String>(comparator);
            this.comments = new ConcurrentSkipListMap<FeatureKey, String>(comparator);
        } else {
            this.storage = new ConcurrentSkipListMap<FeatureKey, String>();
            this.comments = new ConcurrentHashMap<FeatureKey, String>();
        }
        this.changeNotification = changeNotification;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
        this.fireChanged();
    }

    @Override
    public String setTranslation(ContextTranslationKey translationKey, String value, String comment) {
        FeatureKey key = translationKey.getFeatureKey();
        if (key.isEmpty()) {
            return null;
        }
        if (value == null) {
            return this.removeTranslation(translationKey);
        }
        String result = this.storage.put(key, value);
        if (StringUtils.isNullOrEmpty(comment)) {
            this.comments.remove(key);
        } else {
            this.comments.put(key, comment);
        }
        this.fireChanged();
        return result;
    }

    @Override
    public String getTranslation(ContextTranslationKey translationKey) {
        FeatureKey key = translationKey.getFeatureKey();
        if (key.isEmpty()) {
            return null;
        }
        return this.storage.get(key);
    }

    @Override
    public String getComment(ContextTranslationKey translationKey) {
        FeatureKey key = translationKey.getFeatureKey();
        if (key.isEmpty()) {
            return null;
        }
        return this.comments.get(key);
    }

    @Override
    public String removeTranslation(ContextTranslationKey translationKey) {
        FeatureKey key = translationKey.getFeatureKey();
        if (key.isEmpty()) {
            return null;
        }
        String removedValue = this.storage.remove(key);
        this.comments.remove(key);
        this.fireChanged();
        return removedValue;
    }

    protected void fireChanged() {
        if (this.changeNotification != null) {
            this.changeNotification.run();
        }
    }
}

