/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.properties;

import com.e1c.langtool.DictionaryTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.CommonFeatureSettings;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.model.ContextStorageSettings;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.model.ProjectStorageSettings;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import com.e1c.langtool.storage.properties.AbstractPropertiesFileEditor;
import com.e1c.langtool.storage.properties.LineReader;
import com.e1c.langtool.storage.properties.Messages;
import com.e1c.langtool.storage.properties.StringDictionaryData;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class PropertiesDictionaryFileEditor
extends AbstractPropertiesFileEditor<StringDictionaryData> {
    private final ITranslatingProjectManager translatingProjectManager;
    private final IStorageSettingsManager storageSettingsManager;
    private final ITranslationStorageManager translationStorageManager;
    private final IProject project;
    private final StorageID storageId;
    private final StringDictionaryData data;
    private final boolean needToCheckValueGlobally;
    private final String languageCode;
    private final String nonGloballyUniqueValueFormatter;
    private FeatureSettings defaultFeatureSettings;

    public PropertiesDictionaryFileEditor(IFile file, IProject project, DictionaryStorageSettings settings, TranslateLanguage language, ITranslatingProjectManager translatingProjectManager, IStorageSettingsManager storageSettingsManager, ITranslationStorageManager translationStorageManager) {
        super(file);
        this.project = project;
        this.storageId = settings.getStorageId();
        this.translatingProjectManager = translatingProjectManager;
        this.storageSettingsManager = storageSettingsManager;
        this.translationStorageManager = translationStorageManager;
        boolean valueUnique = StorageSettingsUtils.getBooleanSettings(settings, "value_unique", true);
        boolean keyCaseSensitive = StorageSettingsUtils.getBooleanSettings(settings, "key_case_sensitve", false);
        boolean valueCaseSensitive = StorageSettingsUtils.getBooleanSettings(settings, "value_case_sensitive", false);
        String comment = "Translations for: " + settings.getId();
        this.data = valueUnique ? new UniqueValueDictionaryData(keyCaseSensitive, valueCaseSensitive, comment) : new StringDictionaryData(keyCaseSensitive, valueCaseSensitive, comment, this::markDirty);
        this.needToCheckValueGlobally = this.needToCheckValueGlobally(settings);
        this.nonGloballyUniqueValueFormatter = this.getNonGloballyUniqueValueFormatter(settings);
        this.languageCode = language.getLanguageCode();
    }

    @Override
    public boolean isEmpty() {
        return this.data.storage.isEmpty();
    }

    @Override
    public synchronized void load() {
        if (this.needToCheckValueGlobally && this.data instanceof UniqueValueDictionaryData) {
            ((UniqueValueDictionaryData)this.data).valueFixed.set(false);
        }
        this.data.storage.clear();
        this.data.comments.clear();
        super.load();
        if (this.data instanceof UniqueValueDictionaryData) {
            String title = MessageFormat.format(Messages.PropertiesDictionaryFileEditor_Check_and_fix_all_dictionary_values_unique_globally__0, this.file.getFullPath().toString());
            ((UniqueValueDictionaryData)this.data).removeNonUniqueValueEntries();
            Job job = Job.create((String)title, this::checkAndFixAllValuesGlobally);
            job.setRule((ISchedulingRule)this.file);
            job.schedule();
        }
    }

    @Override
    public StringDictionaryData getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeInternal(BufferedWriter bw, boolean escUnicode) throws IOException {
        if (this.data.getComment() != null) {
            PropertiesDictionaryFileEditor.writeComments(bw, this.data.getComment());
            bw.newLine();
        }
        StringDictionaryData stringDictionaryData = this.data;
        synchronized (stringDictionaryData) {
            ArrayList<String> keys = new ArrayList<String>(this.data.storage.keySet());
            keys.sort(null);
            boolean firstLine = true;
            for (String key : keys) {
                String keyComment = this.data.comments.get(key);
                if (!StringUtils.isBlank(keyComment)) {
                    if (!firstLine) {
                        bw.newLine();
                    }
                    String[] lines = keyComment.split(System.lineSeparator());
                    int i = 0;
                    while (i < lines.length) {
                        String line = lines[i];
                        PropertiesDictionaryFileEditor.writeComments(bw, " " + line);
                        ++i;
                    }
                    firstLine = false;
                }
                String val = this.data.storage.get(key);
                String keyString = this.saveConvert(key, true);
                if (val == null) {
                    val = "";
                }
                val = this.saveConvert(val, false);
                bw.write(keyString + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    @Override
    protected void loadInternal(LineReader lr) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        while ((limit = lr.readLine()) >= 0) {
            char c = '\u0000';
            int keyLen = 0;
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            while (keyLen < limit) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
                ++keyLen;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            if (System.lineSeparator() != "\n") {
                value = value.replace("\n", System.lineSeparator());
            }
            this.data.storage.put(key, value);
            if (lr.comment == null) continue;
            String keyComment = String.join((CharSequence)System.lineSeparator(), lr.comment.split("\\n"));
            this.data.comments.put(key, keyComment);
        }
    }

    private boolean needToCheckValueGlobally(DictionaryStorageSettings settings) {
        boolean valueUnique = StorageSettingsUtils.getBooleanSettings(settings, "value_unique", true);
        String postfix = StorageSettingsUtils.getStringSettings(settings, "value_non_global_unique_postfix", "");
        String prefix = StorageSettingsUtils.getStringSettings(settings, "value_non_global_unique_prefix", "");
        return valueUnique && (StringUtils.isNotEmpty(prefix) || StringUtils.isNotEmpty(postfix));
    }

    private String getNonGloballyUniqueValueFormatter(DictionaryStorageSettings settings) {
        String postfix = StorageSettingsUtils.getStringSettings(settings, "value_non_global_unique_postfix", "");
        String prefix = StorageSettingsUtils.getStringSettings(settings, "value_non_global_unique_prefix", "");
        if (StringUtils.isNotEmpty(prefix) || StringUtils.isNotEmpty(postfix)) {
            return prefix + "{0}" + postfix;
        }
        return "";
    }

    private FeatureSettings getDefaultFeatureSettings() {
        if (this.defaultFeatureSettings == null) {
            ProjectStorageSettings projectSettings = this.storageSettingsManager.getSettingsOrDefault(this.project);
            StorageSettings settings = projectSettings.allStorageSettings().get(this.storageId);
            CommonFeatureSettings.Builder builder = new CommonFeatureSettings.Builder().setFeature("name").setModel();
            StorageSettingsUtils.appendFeatureSettingsByStorage(builder, settings);
            this.defaultFeatureSettings = builder.build();
        }
        return this.defaultFeatureSettings;
    }

    private synchronized void checkAndFixAllValuesGlobally(IProgressMonitor monitor) {
        try {
            this.doCheckAndFixAllValuesGlobally(monitor);
        }
        finally {
            ((UniqueValueDictionaryData)this.data).valueFixed.set(true);
        }
    }

    private void doCheckAndFixAllValuesGlobally(IProgressMonitor monitor) {
        if (this.data.storage.isEmpty() || !this.needToCheckValueGlobally || monitor.isCanceled()) {
            return;
        }
        monitor.beginTask(Messages.PropertiesDictionaryFileEditor_Check_all_items, -1);
        Collection<TranslateLanguage> languages = this.translatingProjectManager.getLanguagesForExternalProject(this.file.getProject());
        Optional<TranslateLanguage> language = languages.stream().filter(l -> this.languageCode.equals(l.getLanguageCode())).findAny();
        if (language.isEmpty()) {
            return;
        }
        FeatureSettings featureSettings = this.getDefaultFeatureSettings();
        ArrayList<ITranslationStorageProvider.DictionaryStorage> storages = new ArrayList<ITranslationStorageProvider.DictionaryStorage>();
        ProjectStorageSettings projectSettings = this.storageSettingsManager.getSettingsOrDefault(this.project);
        for (StorageSettings settings : projectSettings.getReadStorageSettings()) {
            ITranslationStorageProvider.Storage storage;
            if (settings instanceof ContextStorageSettings || this.storageId.equals(settings.getStorageId()) || !StorageSettingsUtils.canStoreFeature(settings, featureSettings) || !((storage = this.translationStorageManager.getStorage(this.project, settings.getStorageId())) instanceof ITranslationStorageProvider.DictionaryStorage)) continue;
            storages.add((ITranslationStorageProvider.DictionaryStorage)storage);
        }
        if (monitor.isCanceled()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.PropertiesDictionaryFileEditor_Check_all_items, (int)this.data.storage.size());
        HashSet<String> toUpdate = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.data.storage.entrySet()) {
            DictionaryTranslationKey translationKey = new DictionaryTranslationKey(featureSettings, entry.getKey());
            for (ITranslationStorageProvider.DictionaryStorage storage : storages) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (!storage.hasKeyForValue(entry.getValue(), language.get(), translationKey)) continue;
                toUpdate.add(entry.getKey());
                break;
            }
            subMonitor.worked(1);
        }
        for (String key : toUpdate) {
            if (monitor.isCanceled()) {
                return;
            }
            String value = this.data.storage.get(key);
            value = MessageFormat.format(this.nonGloballyUniqueValueFormatter, value);
            this.data.storage.put(key, value);
        }
        if (!toUpdate.isEmpty() && this.data instanceof UniqueValueDictionaryData) {
            ((UniqueValueDictionaryData)this.data).removeNonUniqueValueEntries();
        }
    }

    private final class UniqueValueDictionaryData
    extends StringDictionaryData {
        private static final long TIMEOUT = 300L;
        private final AtomicBoolean valueFixed;
        private final Object lock;
        protected final Map<String, Collection<String>> keysByValue;

        public UniqueValueDictionaryData(boolean keyCaseSensitive, boolean valueCaseSensitive, String comment) {
            super(keyCaseSensitive, valueCaseSensitive, comment, PropertiesDictionaryFileEditor.this::markDirty);
            this.valueFixed = new AtomicBoolean(true);
            this.lock = new Object();
            this.keysByValue = new ConcurrentHashMap<String, Collection<String>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getTranslation(TranslationKey translationKey) {
            while (PropertiesDictionaryFileEditor.this.needToCheckValueGlobally && !this.valueFixed.get()) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait(300L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return super.getTranslation(translationKey);
        }

        @Override
        public String setTranslation(TranslationKey translationKey, String value, String comment) {
            String result = null;
            if (StringUtils.isNotEmpty(value)) {
                Collection keys = this.keysByValue.computeIfAbsent(value, k -> this.createFeatureKeySet());
                if (keys.isEmpty()) {
                    result = super.setTranslation(translationKey, value, comment);
                    keys.add(translationKey.getValue());
                }
            } else if (value != null) {
                this.keysByValue.remove(value);
            }
            return result;
        }

        @Override
        public String removeTranslation(TranslationKey translationKey) {
            String result = super.removeTranslation(translationKey);
            if (result != null) {
                this.keysByValue.remove(result);
            }
            return result;
        }

        @Override
        public boolean hasKeyForValue(String value, TranslationKey skipKey) {
            if (StringUtils.isNullOrEmpty(value)) {
                return false;
            }
            Collection<String> keys = this.keysByValue.get(value);
            if (keys == null) {
                return false;
            }
            if (skipKey == null) {
                return !keys.isEmpty();
            }
            return keys.size() > 1 || !keys.contains(skipKey.getValue());
        }

        private void updateKeysByValue() {
            this.keysByValue.clear();
            for (Map.Entry entry : this.storage.entrySet()) {
                Collection keys = this.keysByValue.computeIfAbsent((String)entry.getValue(), k -> this.createFeatureKeySet());
                keys.add((String)entry.getKey());
            }
        }

        private Set<String> createFeatureKeySet() {
            if (this.keyCaseSensitive) {
                return new LinkedHashSet<String>();
            }
            return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }

        private void removeNonUniqueValueEntries() {
            this.updateKeysByValue();
            boolean hasChanged = false;
            for (Map.Entry<String, Collection<String>> entry : this.keysByValue.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                Iterator<String> iterator = entry.getValue().iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    if (!iterator.hasNext()) continue;
                    this.storage.remove(key);
                    this.comments.remove(key);
                    hasChanged = true;
                }
            }
            if (hasChanged) {
                this.updateKeysByValue();
            }
        }
    }
}

