/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.properties;

import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.storage.dictionary.DictionaryData;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class StringDictionaryData
implements DictionaryData {
    protected final boolean keyCaseSensitive;
    protected final boolean valueCaseSensitive;
    private String comment;
    protected final Map<String, String> storage;
    protected final Map<String, String> comments;
    private final Runnable changeNotification;
    private volatile Map<String, Collection<String>> keysByValue;

    public StringDictionaryData(boolean keyCaseSensitive, boolean valueCaseSensitive, String comment) {
        this(keyCaseSensitive, valueCaseSensitive, comment, null);
    }

    public StringDictionaryData(boolean keyCaseSensitive, boolean valueCaseSensitive, String comment, Runnable changeNotification) {
        this.keyCaseSensitive = keyCaseSensitive;
        this.valueCaseSensitive = valueCaseSensitive;
        this.comment = comment;
        if (!this.keyCaseSensitive) {
            this.storage = new ConcurrentSkipListMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            this.comments = new ConcurrentSkipListMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        } else {
            this.storage = new ConcurrentSkipListMap<String, String>();
            this.comments = new ConcurrentHashMap<String, String>();
        }
        this.changeNotification = changeNotification;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
        this.fireChanged();
    }

    @Override
    public String setTranslation(TranslationKey translationKey, String value, String comment) {
        String key = translationKey.getValue();
        if (key != null) {
            key = key.trim();
        }
        if (StringUtils.isNullOrEmpty(key)) {
            return null;
        }
        if (value == null) {
            value = "";
        }
        String result = this.storage.put(key, value);
        this.keysByValue = null;
        if (StringUtils.isNullOrEmpty(comment)) {
            this.comments.remove(key);
        } else {
            this.comments.put(key, comment);
        }
        this.fireChanged();
        return result;
    }

    @Override
    public String getTranslation(TranslationKey translationKey) {
        String key = translationKey.getValue();
        if (key != null) {
            key = key.trim();
        }
        if (StringUtils.isNullOrEmpty(key)) {
            return null;
        }
        return this.storage.get(key);
    }

    @Override
    public String getComment(TranslationKey translationKey) {
        String key = translationKey.getValue();
        if (key != null) {
            key = key.trim();
        }
        if (StringUtils.isNullOrEmpty(key)) {
            return null;
        }
        return this.comments.get(key);
    }

    @Override
    public String removeTranslation(TranslationKey translationKey) {
        String key = translationKey.getValue();
        if (key != null) {
            key = key.trim();
        }
        if (StringUtils.isNullOrEmpty(key)) {
            return null;
        }
        String removedValue = this.storage.remove(key);
        this.keysByValue = null;
        this.comments.remove(key);
        this.fireChanged();
        return removedValue;
    }

    @Override
    public boolean hasKeyForValue(String value, TranslationKey skipKey) {
        Collection<String> keys;
        if (StringUtils.isNullOrEmpty(value)) {
            return false;
        }
        if (skipKey == null || StringUtils.isNullOrEmpty(skipKey.getValue())) {
            return this.storage.containsValue(value);
        }
        String skip = skipKey.getValue();
        if (skip != null) {
            skip = skip.trim();
        }
        return (keys = this.getKeysByValue().get(value)) != null && (keys.size() > 1 || !keys.contains(skip));
    }

    protected void fireChanged() {
        if (this.changeNotification != null) {
            this.changeNotification.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Collection<String>> getKeysByValue() {
        if (this.keysByValue == null) {
            StringDictionaryData stringDictionaryData = this;
            synchronized (stringDictionaryData) {
                if (this.keysByValue != null) {
                    return this.keysByValue;
                }
                AbstractMap cache = this.valueCaseSensitive ? new ConcurrentHashMap() : new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER);
                for (Map.Entry<String, String> entry : this.storage.entrySet()) {
                    Collection keys = cache.computeIfAbsent(entry.getValue(), k -> this.keyCaseSensitive ? new HashSet() : new TreeSet(String.CASE_INSENSITIVE_ORDER));
                    keys.add(entry.getKey());
                }
                this.keysByValue = cache;
            }
        }
        return this.keysByValue;
    }
}

