/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.regex;

import com.e1c.langtool.DictionaryTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.dictionary.DictionaryData;
import com.e1c.langtool.storage.regex.RegExUtil;
import com.e1c.langtool.storage.regex.model.RegExItem;
import com.e1c.langtool.storage.regex.model.RegExSettings;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;

public class RegExDictionaryData
implements DictionaryData {
    private static final int MAX_CALLS = 20;
    private final String languageCode;
    private final IProject project;
    private final ITranslatingProjectManager translatingProjectManager;
    private final ITranslationStorageManager storageManager;
    private final ThreadLocal<AtomicInteger> callCounters = new ThreadLocal();
    private volatile RegExSettings settings;
    private Optional<TranslateLanguage> optionalLanguage;

    public RegExDictionaryData(String languageCode, IProject project, ITranslatingProjectManager translatingProjectManager, ITranslationStorageManager storageManager) {
        this.languageCode = languageCode;
        this.project = project;
        this.translatingProjectManager = translatingProjectManager;
        this.storageManager = storageManager;
    }

    public RegExSettings getSettings() {
        return this.settings;
    }

    public void setSettings(RegExSettings settings) {
        this.settings = settings;
    }

    @Override
    public void setComment(String comment) {
        if (this.getSettings() != null) {
            this.getSettings().setComment(comment);
        }
    }

    @Override
    public String getComment() {
        if (this.getSettings() != null) {
            return this.getSettings().getComment();
        }
        return "";
    }

    @Override
    public String removeTranslation(TranslationKey translationKey) {
        return null;
    }

    @Override
    public String getComment(TranslationKey translationKey) {
        return null;
    }

    @Override
    public String getTranslation(TranslationKey translationKey) {
        TranslateLanguage language = this.getTranslateLanguage();
        if (language != null) {
            AtomicInteger callCouner = this.callCounters.get();
            if (callCouner == null) {
                callCouner = new AtomicInteger();
                this.callCounters.set(callCouner);
            }
            if (callCouner.get() > 20) {
                String message = MessageFormat.format("RegEx cycle calls: {0}, value \"{1}\", settings: {2}", callCouner.get(), translationKey.getValue(), translationKey.getFeatureSettings());
                callCouner.set(0);
                CorePlugin.log(CorePlugin.createErrorStatus(message, null));
                return "";
            }
            callCouner.incrementAndGet();
            try {
                IProjectTranslationReader translationReader = this.getProjectTranslationReader();
                String string = this.getTranslation(translationReader, translationKey, language);
                return string;
            }
            finally {
                callCouner.decrementAndGet();
            }
        }
        return null;
    }

    @Override
    public String setTranslation(TranslationKey translationKey, String value, String comment) {
        return null;
    }

    @Override
    public boolean hasKeyForValue(String value, TranslationKey skipKey) {
        return false;
    }

    private String getTranslation(IProjectTranslationReader translationReader, TranslationKey source, TranslateLanguage language) {
        String value = source.getValue();
        if (StringUtils.isBlank(value)) {
            return null;
        }
        for (RegExItem item : this.getSettings().getItems()) {
            String translation;
            if (source.getFeatureSettings().isModel() && !item.isModel() || source.getFeatureSettings().isInterface() && !item.isInterface() || !StringUtils.isNotEmpty(translation = this.getTranslationByItem(item, translationReader, source.getFeatureSettings(), language, value))) continue;
            return translation;
        }
        return null;
    }

    private String getTranslationByItem(RegExItem item, IProjectTranslationReader translationReader, FeatureSettings featureSettings, TranslateLanguage language, String value) {
        if (!item.isValid()) {
            return null;
        }
        Matcher matcher = item.getPattern().matcher(value);
        if (!matcher.matches()) {
            return null;
        }
        List<String> groupNames = RegExUtil.getRegExGroups(item, matcher);
        Map<String, String> translations = groupNames.stream().collect(Collectors.toMap(k -> k, group -> {
            String capturedValue = RegExUtil.getGroupSource(matcher, group);
            if (item.getGroupsFromStorage().contains(group)) {
                DictionaryTranslationKey key;
                String translation;
                if (StringUtils.isNotEmpty(value) && value.equals(capturedValue)) {
                    String message = MessageFormat.format("RegEx \"{0}\" captures from \"{1}\" invalid group #{2} with the same captured value: \"{3}\"", item.getDescription(), value, groupNames.indexOf(group), capturedValue);
                    CorePlugin.log(CorePlugin.createErrorStatus(message, null));
                    return "";
                }
                if (!StringUtils.isBlank(capturedValue) && StringUtils.isNotEmpty(translation = translationReader.getStoredTranslation(key = new DictionaryTranslationKey(featureSettings, capturedValue), language, ITranslationStorageProvider.Storage.Type.COMMON))) {
                    return translation;
                }
                return "";
            }
            return capturedValue;
        }));
        String pattern = item.getTranslation();
        for (Map.Entry<String, String> entry : translations.entrySet()) {
            if (StringUtils.isNullOrEmpty(entry.getValue())) {
                return null;
            }
            pattern = pattern.replace(entry.getKey(), entry.getValue());
        }
        return pattern;
    }

    private TranslateLanguage getTranslateLanguage() {
        if (this.optionalLanguage == null) {
            this.optionalLanguage = this.translatingProjectManager.getProject(this.project).getInterfaceLanguages().stream().filter(l -> this.languageCode.equals(l.getLanguageCode())).findAny();
        }
        return this.optionalLanguage.orElse(null);
    }

    private IProjectTranslationReader getProjectTranslationReader() {
        return this.storageManager.getTranslationReader(this.project);
    }
}

