/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.regex;

import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.regex.AbstractRegExtFileEditor;
import com.e1c.langtool.storage.regex.RegExDictionaryData;
import com.e1c.langtool.storage.regex.RegExUtil;
import com.e1c.langtool.storage.regex.model.RegExSettings;
import com.google.common.hash.HashFunction;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public class RegExDictionaryFileEditor
extends AbstractRegExtFileEditor<RegExDictionaryData> {
    private final RegExDictionaryData data;
    private final String languageCode;

    public RegExDictionaryFileEditor(IFile file, IProject project, DictionaryStorageSettings settings, TranslateLanguage language, ITranslatingProjectManager translatingProjectManager, IStorageSettingsManager storageSettingsManager, ITranslationStorageManager translationStorageManager) {
        super(file);
        this.languageCode = language.getLanguageCode();
        this.data = new RegExDictionaryData(this.languageCode, project, translatingProjectManager, translationStorageManager);
    }

    @Override
    public void save(IProgressMonitor monitor) throws IOException {
        RegExSettings settings = this.data.getSettings();
        if (settings == null) {
            return;
        }
        settings.setLanguageCode(this.languageCode);
        RegExUtil.saveRegExSettings(settings, this.file, monitor);
    }

    @Override
    public byte[] save(HashFunction hashFunction, IProgressMonitor monitor) throws IOException {
        RegExSettings settings = this.data.getSettings();
        if (settings == null) {
            return null;
        }
        settings.setLanguageCode(this.languageCode);
        return RegExUtil.saveRegExSettings(settings, this.file, hashFunction, monitor);
    }

    @Override
    public boolean isEmpty() {
        return this.data.getSettings() == null || this.data.getSettings().getItems().isEmpty();
    }

    @Override
    public void load() {
        RegExSettings settings = RegExUtil.loadSettings(this.file);
        if (settings == null) {
            settings = new RegExSettings();
        }
        this.data.setSettings(settings);
    }

    @Override
    public RegExDictionaryData getData() {
        return this.data;
    }
}

