/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.regex;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.regex.RegExFile;
import com.e1c.langtool.storage.regex.SettingsYamlConstructor;
import com.e1c.langtool.storage.regex.YamlRegExFile;
import com.e1c.langtool.storage.regex.model.RegExItem;
import com.e1c.langtool.storage.regex.model.RegExSettings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.HashingOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class RegExUtil {
    private static final String GROUP_PREFIX = "${";
    private static final String GROUP_SUFFIX = "}";
    public static final String REG_EX_FILE_EXTENSION = "yml";
    public static final String TRANS_FILE_COMMENT_PREFIX = "Translations for:";

    public static RegExFile createRegExFile(TranslateLanguage language, IFile file, String segment) {
        return new YamlRegExFile(language.getLanguageCode(), file, RegExUtil.generateComment(segment));
    }

    public static String generateComment(String segment) {
        StringBuilder comment = new StringBuilder();
        comment.append(TRANS_FILE_COMMENT_PREFIX);
        comment.append(" ");
        comment.append(segment);
        return comment.toString();
    }

    public static IFile getRegExFilePath(IFile source, TranslateLanguage language, String segment) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(segment);
        fileName.append("_");
        fileName.append("regex");
        fileName.append("_");
        fileName.append(language.getLanguageCode());
        IPath path = source.getProjectRelativePath().removeLastSegments(1);
        path = path.append(fileName.toString()).addFileExtension(REG_EX_FILE_EXTENSION);
        return source.getProject().getFile(path);
    }

    private RegExUtil() {
        throw new IllegalAccessError("Utility class.");
    }

    public static Set<String> getNamedGroupCandidates(String regex) {
        TreeSet namedGroups = Sets.newTreeSet();
        Matcher m = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>").matcher(regex);
        while (m.find()) {
            namedGroups.add(m.group(1));
        }
        return namedGroups;
    }

    public static List<String> getRegExGroups(RegExItem item) {
        return RegExUtil.getRegExGroups(item, null);
    }

    public static List<String> getRegExGroups(RegExItem item, Matcher matcher) {
        ArrayList groups = Lists.newArrayList();
        Pattern pattern = item.getPattern();
        if (pattern == null) {
            return groups;
        }
        if (matcher == null) {
            if (StringUtils.isNullOrEmpty(item.getTestString())) {
                return groups;
            }
            matcher = pattern.matcher(item.getTestString());
        }
        if (!matcher.matches()) {
            return groups;
        }
        Set<String> namedGroups = RegExUtil.getNamedGroupCandidates(item.getRegEx());
        for (String group : namedGroups) {
            try {
                matcher.group(group);
                groups.add(RegExUtil.getGroupPresentation(group));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        int i = 1;
        while (i <= matcher.groupCount()) {
            groups.add(RegExUtil.getGroupPresentation(Integer.toString(i)));
            ++i;
        }
        return groups;
    }

    public static String getGroupPresentation(String group) {
        Assert.isLegal((!StringUtils.isBlank(group) ? 1 : 0) != 0);
        return GROUP_PREFIX + group + GROUP_SUFFIX;
    }

    public static String getGroupNameFromPresentation(String group) {
        Assert.isLegal((!StringUtils.isBlank(group) ? 1 : 0) != 0);
        if (group.startsWith(GROUP_PREFIX) && group.endsWith(GROUP_SUFFIX)) {
            return group.substring(0, group.length() - 1).substring(2);
        }
        return null;
    }

    public static String getGroupSource(Matcher matcher, String groupName) {
        if (!matcher.matches()) {
            return "";
        }
        String name = RegExUtil.getGroupNameFromPresentation(groupName);
        if (StringUtils.isNullOrEmpty(name)) {
            return "";
        }
        try {
            int index = Integer.parseInt(name);
            if (index > 0 && index <= matcher.groupCount()) {
                return matcher.group(index);
            }
        }
        catch (IllegalStateException e) {
            return "";
        }
        catch (NumberFormatException e) {
            try {
                return matcher.group(name);
            }
            catch (IllegalArgumentException | IllegalStateException e2) {
                return "";
            }
        }
        return "";
    }

    public static void saveRegExSettings(RegExSettings settings, IFile file, IProgressMonitor monitor) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setLineBreak(DumperOptions.LineBreak.getPlatformLineBreak());
        Representer representer = new Representer(){

            protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                if (propertyValue == null) {
                    return null;
                }
                return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
            }
        };
        representer.getPropertyUtils().setSkipMissingProperties(true);
        Yaml yaml = new Yaml(representer, options);
        yaml.setBeanAccess(BeanAccess.FIELD);
        yaml.addTypeDescription(RegExUtil.createRegExSettingsTypeDescription());
        yaml.dump((Object)settings, (Writer)writer);
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());){
                if (file.exists()) {
                    file.setContents((InputStream)input, true, true, monitor);
                } else {
                    file.create((InputStream)input, true, monitor);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            CorePlugin.logError(e);
        }
    }

    public static byte[] saveRegExSettings(RegExSettings settings, IFile file, HashFunction hashFunction, IProgressMonitor monitor) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        HashingOutputStream out = new HashingOutputStream(hashFunction, (OutputStream)byteOutputStream);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setLineBreak(DumperOptions.LineBreak.getPlatformLineBreak());
        Representer representer = new Representer(){

            protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                if (propertyValue == null) {
                    return null;
                }
                return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
            }
        };
        representer.getPropertyUtils().setSkipMissingProperties(true);
        Yaml yaml = new Yaml(representer, options);
        yaml.setBeanAccess(BeanAccess.FIELD);
        yaml.addTypeDescription(RegExUtil.createRegExSettingsTypeDescription());
        yaml.dump((Object)settings, (Writer)writer);
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(byteOutputStream.toByteArray());){
                if (file.exists()) {
                    file.setContents((InputStream)input, true, true, monitor);
                } else {
                    file.create((InputStream)input, true, monitor);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            CorePlugin.logError(e);
        }
        return out.hash().asBytes();
    }

    private static TypeDescription createRegExSettingsTypeDescription() {
        TypeDescription descr = new TypeDescription(RegExSettings.class, new Tag(RegExSettings.class));
        descr.setIncludes(new String[]{"languageCode", "comment", "items"});
        return descr;
    }

    public static RegExSettings loadSettings(IFile file) {
        if (file.exists()) {
            SettingsYamlConstructor cnstr = new SettingsYamlConstructor();
            Yaml yaml = new Yaml((BaseConstructor)cnstr);
            yaml.setBeanAccess(BeanAccess.FIELD);
            cnstr.getPropertyUtils().setSkipMissingProperties(true);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream inputStream = file.getContents();){
                    return (RegExSettings)yaml.loadAs(inputStream, RegExSettings.class);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                CorePlugin.logError(e);
            }
        }
        return null;
    }
}

