/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.regex;

import com.e1c.langtool.DictionaryTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.regex.AbstractRegExtFileEditor;
import com.e1c.langtool.storage.regex.RegExFile;
import com.e1c.langtool.storage.regex.RegExUtil;
import com.e1c.langtool.storage.regex.model.RegExItem;
import com.e1c.langtool.storage.regex.model.RegExSettings;
import com.google.common.hash.HashFunction;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class YamlRegExFile
extends AbstractRegExtFileEditor<RegExSettings>
implements RegExFile {
    private RegExSettings settings;
    private volatile boolean dirty = false;
    private final String languageCode;
    private String comment;

    public YamlRegExFile(String languageCode, IFile file, String comment) {
        super(file);
        this.languageCode = languageCode;
        this.comment = comment;
    }

    @Override
    public RegExSettings getData() {
        return this.settings;
    }

    @Override
    public void save(IProgressMonitor monitor) throws IOException {
        if (this.settings == null) {
            return;
        }
        if (StringUtils.isNotEmpty(this.languageCode) && StringUtils.isNullOrEmpty(this.settings.getLanguageCode())) {
            this.settings.setLanguageCode(this.languageCode);
        }
        if (StringUtils.isNotEmpty(this.comment) && StringUtils.isNullOrEmpty(this.settings.getComment())) {
            this.settings.setComment(this.comment);
        }
        RegExUtil.saveRegExSettings(this.settings, this.file, monitor);
        this.dirty = false;
    }

    @Override
    public byte[] save(HashFunction hashFunction, IProgressMonitor monitor) throws IOException {
        if (this.settings == null) {
            return null;
        }
        if (StringUtils.isNotEmpty(this.languageCode) && StringUtils.isNullOrEmpty(this.settings.getLanguageCode())) {
            this.settings.setLanguageCode(this.languageCode);
        }
        if (StringUtils.isNotEmpty(this.comment) && StringUtils.isNullOrEmpty(this.settings.getComment())) {
            this.settings.setComment(this.comment);
        }
        byte[] result = RegExUtil.saveRegExSettings(this.settings, this.file, hashFunction, monitor);
        this.dirty = false;
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void load() {
        this.settings = RegExUtil.loadSettings(this.file);
        if (this.settings == null) {
            this.settings = new RegExSettings();
        }
        if (StringUtils.isNotEmpty(this.languageCode) && StringUtils.isNullOrEmpty(this.settings.getLanguageCode())) {
            this.settings.setLanguageCode(this.languageCode);
        }
        this.dirty = false;
    }

    @Override
    public List<RegExItem> getItems() {
        return this.settings.getItems();
    }

    @Override
    public void addItem(RegExItem item) {
        this.settings.getItems().add(item);
        this.markDirty();
    }

    @Override
    public void removeItem(RegExItem item) {
        if (this.settings.getItems().remove(item)) {
            this.markDirty();
        }
    }

    @Override
    public void removeAllItems(String regExText) {
        Iterator<RegExItem> iterator = this.getItems().iterator();
        while (iterator.hasNext()) {
            RegExItem item = iterator.next();
            if ((regExText != null || item.getRegEx() != null) && (regExText == null || !regExText.equals(item.getRegEx()))) continue;
            iterator.remove();
            this.markDirty();
        }
    }

    @Override
    public String getTranslation(ITranslationStorageProvider.DictionaryStorage dictionary, TranslationKey source, TranslateLanguage language) {
        String value = source.getValue();
        if (StringUtils.isBlank(value)) {
            return null;
        }
        for (RegExItem item : this.getItems()) {
            String translation;
            if (source.getFeatureSettings().isModel() && !item.isModel() || source.getFeatureSettings().isInterface() && !item.isInterface() || !StringUtils.isNotEmpty(translation = this.getTranslationByItem(item, dictionary, source.getFeatureSettings(), language, value))) continue;
            return translation;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.settings.isEmpty();
    }

    private String getTranslationByItem(RegExItem item, ITranslationStorageProvider.DictionaryStorage dictionary, FeatureSettings featureSettings, TranslateLanguage language, String value) {
        if (!item.isValid()) {
            return null;
        }
        Matcher matcher = item.getPattern().matcher(value);
        if (!matcher.matches()) {
            return null;
        }
        List<String> groupNames = RegExUtil.getRegExGroups(item, matcher);
        Map<String, String> translations = groupNames.stream().collect(Collectors.toMap(k -> k, group -> {
            String capturedValue = RegExUtil.getGroupSource(matcher, group);
            if (item.getGroupsFromStorage().contains(group)) {
                DictionaryTranslationKey key;
                String translation;
                if (!StringUtils.isBlank(capturedValue) && StringUtils.isNotEmpty(translation = dictionary.getTranslation(key = new DictionaryTranslationKey(featureSettings, capturedValue), language))) {
                    return translation;
                }
                return "";
            }
            return capturedValue;
        }));
        String pattern = item.getTranslation();
        for (Map.Entry<String, String> entry : translations.entrySet()) {
            if (StringUtils.isNullOrEmpty(entry.getValue())) {
                return null;
            }
            pattern = pattern.replace(entry.getKey(), entry.getValue());
        }
        return pattern;
    }
}

