/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.translator;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.CollectingFilterParticipant;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.e1c.langtool.v8.dt.translator.IComputedNameTranslationService;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelStringsContextTranslationCache;
import com.e1c.langtool.v8.dt.translator.ProjectTranslationProviderCache;
import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class ComputedStringFilter
implements CollectingFilterParticipant {
    public static final String PARAM_NAME = "fill-collected-string-by-translated-project";
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private ProjectTranslationProviderCache translationProviderCache;
    @Inject
    protected IComputedNameTranslationService computedNameTranslationService;

    public boolean canUseCollectingCache(Map<String, Object> parameters) {
        return !parameters.containsKey(PARAM_NAME);
    }

    public boolean canCollect(TranslationSource source, Map<String, Object> parameters, IProgressMonitor monitor) {
        return !monitor.isCanceled();
    }

    public boolean needCollectRaw(TranslationSource source, Object sourceObject, FeatureValue value, Map<String, Object> parameters, IProgressMonitor monitor) {
        if (!parameters.containsKey(PARAM_NAME)) {
            return !monitor.isCanceled();
        }
        IProject project = source.getProject();
        if (project == null) {
            return !monitor.isCanceled();
        }
        ITranslatedProject translatedProject = this.getParameter(parameters, PARAM_NAME, source);
        if (translatedProject instanceof ITranslatedV8Project) {
            if (value.isComputedValue() && sourceObject instanceof EObject && value.getContextKey().getFeatureSettings() instanceof EFeatureSettings) {
                ITranslatedV8Project translatedV8Project = (ITranslatedV8Project)translatedProject;
                IProjectTranslationProvider projectTranslationProvider = this.translationProviderCache.get(translatedV8Project);
                String translation = this.computeTranslatedString((EObject)sourceObject, (EFeatureSettings)value.getContextKey().getFeatureSettings(), projectTranslationProvider);
                TranslateLanguage defaultLanguage = translatedV8Project.getDefaultLanguage();
                if (StringUtils.isNullOrEmpty((String)translation)) {
                    translation = projectTranslationProvider.getTranslation((EObject)sourceObject, value.getContextKey(), defaultLanguage);
                }
                if (StringUtils.isNotEmpty((String)translation)) {
                    value.getLocalStrings().put(defaultLanguage.getLanguageCode(), translation);
                    ModelStringsContextTranslationCache cache = projectTranslationProvider.getCache(ModelStringsContextTranslationCache.class);
                    cache.putTranslation(value.getContextKey(), translation);
                }
            } else {
                return false;
            }
        }
        return !monitor.isCanceled();
    }

    private ITranslatedProject getParameter(Map<String, Object> parameters, String key, TranslationSource translationSource) {
        Object value = parameters.get(key);
        if (value instanceof ITranslatedProject) {
            return (ITranslatedProject)value;
        }
        if (value instanceof String) {
            IProject iProject = translationSource.getProject();
            ITranslatingProject sourceProject = this.translatingProjectManager.getProject(iProject);
            for (ITranslatedProject translatedProject : sourceProject.getTranslatedProjects()) {
                if (!value.equals(translatedProject.getProjectName())) continue;
                parameters.put(key, translatedProject);
                return translatedProject;
            }
        }
        return null;
    }

    private String computeTranslatedString(EObject source, EFeatureSettings featureSettings, IProjectTranslationProvider projectTranslationProvider) {
        String translation = null;
        ITranslatedV8Project translatedProject = projectTranslationProvider.getProject();
        if ((translatedProject.isChangeDefaultLanguage() || translatedProject.isChangeScriptVariant()) && featureSettings.isModel()) {
            translation = this.computedNameTranslationService.computeTranslatedString(source, featureSettings, projectTranslationProvider, translatedProject.getDefaultLanguage());
        }
        return translation;
    }
}

