/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.translator;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.collector.IComputedNameService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.ignore.IgnoreTranslationCheckingService;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.internal.translator.CorePlugin;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.e1c.langtool.v8.dt.translator.IComputedNameTranslationService;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelStringsContextTranslationCache;
import com.e1c.langtool.v8.dt.translator.SessionCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.Arrays;

public class ProjectTranslationProvider
implements IProjectTranslationProvider {
    @Inject
    protected IResourceLookup resourceLookup;
    @Inject
    protected ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    protected IComputedNameService computedNameService;
    @Inject
    protected IComputedNameTranslationService computedNameTranslationService;
    @Inject
    protected TranslationPreferences preferences;
    @Inject
    protected IgnoreTranslationCheckingService ignoreService;
    @Inject
    protected ITranslationStorageManager storageManager;
    private final ITranslatedV8Project translatedProject;
    private final Map<Class<?>, SessionCache> cache = Maps.newConcurrentMap();
    private TranslationProperties translationProperties;
    private IProjectTranslationReader projectTranslationReader;

    public static ProjectTranslationProvider create(ITranslatedV8Project translatedProject) {
        Assert.isLegal((translatedProject != null ? 1 : 0) != 0, (String)"translatedProject should not be null");
        ProjectTranslationProvider provider = new ProjectTranslationProvider(translatedProject);
        CorePlugin.getDefault().getInjector().injectMembers((Object)provider);
        return provider;
    }

    protected ProjectTranslationProvider(ITranslatedV8Project translatedProject) {
        this.translatedProject = translatedProject;
    }

    @Override
    public ITranslatedV8Project getProject() {
        return this.translatedProject;
    }

    @Override
    public String getStoredTranslation(ContextTranslationKey key, TranslateLanguage language, ITranslationStorageProvider.Storage.Type ... storageTypes) {
        if (key.getFeatureSettings().isModel() && (storageTypes == null || Arrays.contains((Object[])storageTypes, (Object)ITranslationStorageProvider.Storage.Type.CONTEXT))) {
            ModelStringsContextTranslationCache cache = this.getCache(ModelStringsContextTranslationCache.class);
            return cache.getTranslation(key, (Provider<String>)((Provider)() -> this.getStoredTranslationInternal(key, language, storageTypes)));
        }
        return this.getStoredTranslationInternal(key, language, storageTypes);
    }

    protected String getStoredTranslationInternal(ContextTranslationKey key, TranslateLanguage language, ITranslationStorageProvider.Storage.Type ... storageTypes) {
        if (this.ignoreService.ignoreTranslation(this.getSourceProject(), key, (IProgressMonitor)new NullProgressMonitor())) {
            return key.getValue();
        }
        String translation = this.getReader().getStoredTranslation((TranslationKey)key, language, storageTypes);
        if (key.getFeatureSettings().isInterface() && StringUtils.isNullOrEmpty((String)translation) && this.getTranslationProperties().fillEmptyInterfaceTranslation()) {
            TranslateLanguage newLanguage = this.getTranslationProperties().getLanguageToFillEmptyInterfaceTranslation(language);
            HashSet checked = Sets.newHashSet();
            checked.add(language.getLanguageCode());
            while (newLanguage != null && !checked.contains(newLanguage.getLanguageCode()) && this.translatedProject.getInterfaceLanguages().contains(newLanguage)) {
                translation = this.getReader().getStoredTranslation((TranslationKey)key, newLanguage, storageTypes);
                if (StringUtils.isNullOrEmpty((String)translation)) {
                    checked.add(newLanguage.getLanguageCode());
                    newLanguage = this.getTranslationProperties().getLanguageToFillEmptyInterfaceTranslation(language);
                    continue;
                }
                return translation;
            }
            if (this.getTranslationProperties().fillEmptyInterfaceTranslationFromSource()) {
                newLanguage = this.getProject().getDefaultLanguage();
                translation = this.getReader().getStoredTranslation((TranslationKey)key, newLanguage, storageTypes);
            }
            if (StringUtils.isNullOrEmpty((String)translation) && this.getProject().isChangeDefaultLanguage()) {
                translation = key.getValue();
            }
        }
        if (translation == null) {
            translation = "";
        }
        return translation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProjectTranslationReader getReader() {
        if (this.projectTranslationReader == null) {
            ProjectTranslationProvider projectTranslationProvider = this;
            synchronized (projectTranslationProvider) {
                if (this.projectTranslationReader != null) {
                    return this.projectTranslationReader;
                }
                this.projectTranslationReader = this.storageManager.getTranslationReader(this.getSourceProject());
            }
        }
        return this.projectTranslationReader;
    }

    @Override
    public String getTranslation(EObject source, EFeatureSettings featureSettings, TranslateLanguage language) {
        IFile file = this.resourceLookup.getPlatformResource(source);
        if (file == null) {
            return null;
        }
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey(source, (FeatureSettings)featureSettings);
        String value = FeaturesCollectorUtil.getSourceValue((EObject)source, (EFeatureSettings)featureSettings, (String)this.getSourceConfigurationLanguageCode());
        ContextTranslationKeyImpl key = new ContextTranslationKeyImpl(file, featureKey, (FeatureSettings)featureSettings, value);
        return this.getTranslation(source, (ContextTranslationKey)key, language);
    }

    @Override
    public Optional<String> getOptionalTranslation(EObject source, EFeatureSettings featureSettings, TranslateLanguage language) {
        String translation = this.getTranslation(source, featureSettings, language);
        if (translation != null && StringUtils.isNullOrEmpty((String)translation)) {
            translation = null;
        }
        return Optional.ofNullable(translation);
    }

    @Override
    public Optional<String> getOptionalTranslation(EObject source, ContextTranslationKey key, TranslateLanguage language) {
        String translation = this.getTranslation(source, key, language);
        if (translation != null && StringUtils.isNullOrEmpty((String)translation)) {
            translation = null;
        }
        return Optional.ofNullable(translation);
    }

    @Override
    public String getTranslation(EObject source, ContextTranslationKey key, TranslateLanguage language) {
        String translation = this.getStoredTranslation(key, language, new ITranslationStorageProvider.Storage.Type[0]);
        if (StringUtils.isNotEmpty((String)translation)) {
            return translation;
        }
        if (key.getFeatureSettings() instanceof EFeatureSettings) {
            translation = this._computeTranslatedString(source, (EFeatureSettings)key.getFeatureSettings());
        }
        return translation;
    }

    private TranslationProperties getTranslationProperties() {
        if (this.translationProperties == null) {
            this.translationProperties = this.preferences.getTranslationProperties(this.getSourceProject());
        }
        return this.translationProperties;
    }

    private String _computeTranslatedString(EObject source, EFeatureSettings featureSettings) {
        String translation = null;
        if ((this.translatedProject.isChangeDefaultLanguage() || this.translatedProject.isChangeScriptVariant()) && featureSettings.isModel() && this.computedNameService.isComputedString(source, featureSettings)) {
            translation = this.computedNameTranslationService.computeTranslatedString(source, featureSettings, this, this.translatedProject.getDefaultLanguage());
        }
        return translation;
    }

    private String getSourceConfigurationLanguageCode() {
        Assert.isNotNull((Object)this.translatedProject);
        ITranslatingProject source = this.translatedProject.getSourceProject();
        Assert.isNotNull((Object)source);
        TranslateLanguage defaultLanguage = source.getDefaultLanguage();
        Assert.isNotNull((Object)defaultLanguage);
        return defaultLanguage.getLanguageCode();
    }

    protected IProject getSourceProject() {
        Assert.isNotNull((Object)this.translatedProject);
        ITranslatingProject source = this.translatedProject.getSourceProject();
        Assert.isNotNull((Object)source);
        return source.getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends SessionCache> T getCache(Class<T> clazz) {
        if (this.cache.containsKey(clazz)) {
            return (T)this.cache.get(clazz);
        }
        ProjectTranslationProvider projectTranslationProvider = this;
        synchronized (projectTranslationProvider) {
            if (!this.cache.containsKey(clazz)) {
                SessionCache in;
                try {
                    in = (SessionCache)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    in.init(this);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    CorePlugin.logError(e);
                    return null;
                }
                this.cache.put(clazz, in);
            }
            return (T)this.cache.get(clazz);
        }
    }

    @Override
    public Collection<SessionCache> allCaches() {
        return ImmutableList.copyOf(this.cache.values());
    }
}

