/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.translator;

import com.e1c.langtool.v8.dt.internal.translator.CorePlugin;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ProjectTranslationProvider;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;

@Singleton
public final class ProjectTranslationProviderCache
implements RemovalListener<ITranslatedV8Project, IProjectTranslationProvider> {
    private static final long EXPARATION_MINUTES = 20L;
    private final Cache<ITranslatedV8Project, IProjectTranslationProvider> projectProviders = CacheBuilder.newBuilder().expireAfterAccess(20L, TimeUnit.MINUTES).removalListener((RemovalListener)this).build();

    public @NonNull IProjectTranslationProvider get(ITranslatedV8Project project) {
        try {
            return (IProjectTranslationProvider)this.projectProviders.get((Object)project, () -> ProjectTranslationProvider.create(project));
        }
        catch (ExecutionException e) {
            CorePlugin.logError(e);
            return ProjectTranslationProvider.create(project);
        }
    }

    public void onRemoval(RemovalNotification<ITranslatedV8Project, IProjectTranslationProvider> notification) {
        ((IProjectTranslationProvider)notification.getValue()).dispose();
    }
}

