/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.microsoft;

import com._1c.g5.wiring.InjectorAwareServiceRegistrator;
import com._1c.g5.wiring.ServiceInitialization;
import com.e1c.langtool.microsoft.ITokenProvider;
import com.e1c.langtool.microsoft.internal.ServiceModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;

public class CorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.microsoft";
    private static CorePlugin plugin;
    private IEclipsePreferences preferenceStore;
    private volatile Injector injector;
    private InjectorAwareServiceRegistrator registrator;

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        CorePlugin.log(CorePlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initPreferences();
        this.registrator = new InjectorAwareServiceRegistrator(context, this::getInjector);
        ServiceInitialization.schedule(() -> this.registrator.service(ITokenProvider.class).registerInjected());
    }

    public void stop(BundleContext context) throws Exception {
        this.registrator.unregisterServices();
        this.registrator = null;
        plugin = null;
        this.injector = null;
        super.stop(context);
    }

    public IEclipsePreferences getPreferenceStore() {
        return this.preferenceStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<CorePlugin> clazz = CorePlugin.class;
        synchronized (CorePlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    protected void initPreferences() {
        this.preferenceStore = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ServiceModule()});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }
}

