/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.microsoft;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.external.ExternalApiAccessLimit;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.external.ServiceUnavailableException;
import com.e1c.langtool.external.TranslationServiceException;
import com.e1c.langtool.microsoft.CorePlugin;
import com.e1c.langtool.microsoft.ITokenProvider;
import com.e1c.langtool.microsoft.Messages;
import com.e1c.langtool.microsoft.MicrosoftServiceConstants;
import com.e1c.langtool.microsoft.entity.ErrorResponse;
import com.e1c.langtool.microsoft.entity.SupportedLanguages;
import com.e1c.langtool.microsoft.entity.TranslationRequest;
import com.e1c.langtool.microsoft.entity.TranslationsResponse;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;

public class MicrosoftTranslatorProvider
implements IExternalTranslationProvider {
    public static final String PROVIDER_ID = "com.e1c.langtool.microsoft.microsoftTranslatorProvider";
    private static final String APPLICATION_JSON = "application/json; charset=UTF-8";
    private static final String API_URL = "https://api.cognitive.microsofttranslator.com";
    private static final String API_VERSION = "3.0";
    public static final String GET_LANGUAGES_METHOD = "languages";
    private static final String GET_TRANSLATIONS_METHOD = "translate";
    private static final String PARAM_API_VERSION = "api-version";
    private static final String PARAM_CATEGORY = "category";
    private static final String PARAM_SCOPE = "scope";
    private static final String PARAM_SCOPE_VALUE = "translation";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_TO = "to";
    public static final String TOKEN_PREFIX = "Bearer";
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(3L);
    private static final int ACCESS_API_PER_SECOND = 0;
    private static final int SYMBOLS_PER_MINUTE = 33300;
    private static final int SYMBOLS_PER_SECOND = 1800;
    protected final HttpClient client;
    private final Gson gson;
    private final ExternalApiAccessLimit limits;
    private final ExternalApiAccessLimit userModelLimits;
    private ITokenProvider tokenProvider;

    @Inject
    public MicrosoftTranslatorProvider(ITokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
        this.client = this.createClient();
        this.gson = new Gson();
        this.limits = new ExternalApiAccessLimit(Duration.ofSeconds(1L), 0, Duration.ofMinutes(1L), 33300);
        this.userModelLimits = new ExternalApiAccessLimit(Duration.ofSeconds(1L), 0, Duration.ofSeconds(1L), 1800);
    }

    public String getTranslationItemImageName() {
        return "icons/obj16/microsoft.png";
    }

    public List<String> translate(String text, String sourceLocale, String targetLocale) {
        if (text == null) {
            throw new IllegalArgumentException("The given text to translate is null");
        }
        HttpRequest request = this.createTranslateRequest(Arrays.asList(text), sourceLocale, targetLocale);
        String category = this.getCategoryId();
        if (StringUtils.isNotEmpty((String)category)) {
            this.userModelLimits.checkOrWaitSymbolLimits(text.length());
        } else {
            this.limits.checkOrWaitSymbolLimits(text.length());
        }
        HttpResponse<String> response = this.safeExec(request);
        this.handleError(response);
        TranslationsResponse[] entity = (TranslationsResponse[])this.gson.fromJson(response.body(), TranslationsResponse[].class);
        if (entity != null && entity.length > 0) {
            return entity[0].getTranslations().stream().map(TranslationsResponse.TranslationResult::getText).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Map<String, List<String>> translate(List<String> texts, String sourceLocale, String targetLocale) {
        for (String text : texts) {
            if (text != null) continue;
            throw new IllegalArgumentException("The given text to translate is null");
        }
        HttpRequest request = this.createTranslateRequest(texts, sourceLocale, targetLocale);
        int total = texts.stream().collect(Collectors.summingInt(String::length));
        String category = this.getCategoryId();
        if (StringUtils.isNotEmpty((String)category)) {
            this.userModelLimits.checkOrWaitSymbolLimits(total);
        } else {
            this.limits.checkOrWaitSymbolLimits(total);
        }
        HttpResponse<String> response = this.safeExec(request);
        this.handleError(response);
        TranslationsResponse[] entity = (TranslationsResponse[])this.gson.fromJson(response.body(), TranslationsResponse[].class);
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        int i = 0;
        while (i < texts.size()) {
            String text = texts.get(i);
            if (i < entity.length) {
                TranslationsResponse item = entity[i];
                List translations = item.getTranslations().stream().map(TranslationsResponse.TranslationResult::getText).collect(Collectors.toList());
                res.put(text, translations);
            } else {
                res.put(text, Collections.emptyList());
            }
            ++i;
        }
        return res;
    }

    public Set<String> getLanguageCodes() {
        HttpRequest request = this.createGettingLanguagesRequest(null);
        HttpResponse<String> response = this.safeExec(request);
        this.handleError(response);
        SupportedLanguages languages = (SupportedLanguages)this.gson.fromJson(response.body(), SupportedLanguages.class);
        return new TreeSet<String>(languages.getTranslation().keySet());
    }

    public Map<String, String> getLanguages(String targetLocale) {
        HttpRequest request = this.createGettingLanguagesRequest(targetLocale);
        HttpResponse<String> response = this.safeExec(request);
        this.handleError(response);
        SupportedLanguages languages = (SupportedLanguages)this.gson.fromJson(response.body(), SupportedLanguages.class);
        return new TreeMap<String, String>(languages.getTranslation().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((SupportedLanguages.LanguageDescription)e.getValue()).getName())));
    }

    public boolean isActive() {
        return true;
    }

    protected HttpRequest createTranslateRequest(List<String> texts, String sourceLocale, String targetLocale) {
        ArrayList<TranslationRequest> request = new ArrayList<TranslationRequest>();
        for (String text : texts) {
            TranslationRequest item = new TranslationRequest();
            item.setText(text);
            request.add(item);
        }
        String tokenText = this.tokenProvider.getActiveTokenText(this.getAppKey());
        String auth = "Bearer " + tokenText;
        String requestBody = this.gson.toJson(request);
        HttpRequest.Builder builder = HttpRequest.newBuilder().header("Content-Type", APPLICATION_JSON).header("Authorization", auth).timeout(REQUEST_TIMEOUT).version(HttpClient.Version.HTTP_1_1).POST(HttpRequest.BodyPublishers.ofString(requestBody));
        URI uri = URI.create(API_URL);
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setHost(uri.getHost()).setScheme(uri.getScheme()).setPath(GET_TRANSLATIONS_METHOD).addParameter(PARAM_API_VERSION, API_VERSION).addParameter(PARAM_FROM, sourceLocale).addParameter(PARAM_TO, targetLocale);
        String category = this.getCategoryId();
        if (StringUtils.isNotEmpty((String)category)) {
            uriBuilder.addParameter(PARAM_CATEGORY, category);
        }
        try {
            builder.uri(uriBuilder.build());
        }
        catch (URISyntaxException e) {
            CorePlugin.logError(e);
        }
        return builder.build();
    }

    protected HttpRequest createGettingLanguagesRequest(String targetLocale) {
        URI uri = URI.create(API_URL);
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setHost(uri.getHost()).setScheme(uri.getScheme()).setPath(GET_LANGUAGES_METHOD).addParameter(PARAM_API_VERSION, API_VERSION).addParameter(PARAM_SCOPE, PARAM_SCOPE_VALUE);
        try {
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            CorePlugin.logError(e);
        }
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uri).header("Content-Type", APPLICATION_JSON).timeout(REQUEST_TIMEOUT).version(HttpClient.Version.HTTP_1_1).GET();
        if (StringUtils.isNotEmpty((String)targetLocale)) {
            builder.header("Accept-Language", targetLocale);
        }
        return builder.build();
    }

    protected HttpClient createClient() {
        return HttpClient.newBuilder().connectTimeout(Duration.ofMillis(5000L)).proxy(ProxySelector.getDefault()).build();
    }

    private String getAppKey() {
        return CorePlugin.getDefault().getPreferenceStore().get("apiKey", MicrosoftServiceConstants.DEFAUTL_APP_KEY);
    }

    private String getCategoryId() {
        return CorePlugin.getDefault().getPreferenceStore().get("categoryId", MicrosoftServiceConstants.DEFAUTL_CATEGORY_ID);
    }

    private HttpResponse<String> safeExec(HttpRequest request) {
        try {
            return this.client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException e) {
            throw new ServiceUnavailableException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TranslationServiceException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TranslationServiceException((Throwable)e);
        }
    }

    private void handleError(HttpResponse<String> response) {
        String message = response.body();
        if (response.statusCode() != 200) {
            try {
                ErrorResponse errorResponse = (ErrorResponse)this.gson.fromJson(message, ErrorResponse.class);
                if (errorResponse != null && errorResponse.getError() != null && StringUtils.isNotEmpty((String)errorResponse.getError().getMessage())) {
                    message = String.join((CharSequence)", ", String.valueOf(errorResponse.getError().getCode()), errorResponse.getError().getMessage());
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        switch (response.statusCode()) {
            case 200: {
                break;
            }
            case 400: {
                throw new TranslationServiceException(Messages.MicrosoftTranslatorProvider_400ErrorMsg + message);
            }
            case 401: {
                throw new TranslationServiceException(Messages.MicrosoftTranslatorProvider_401ErrorMsg + message);
            }
            case 500: {
                throw new TranslationServiceException(Messages.MicrosoftTranslatorProvider_500ErrorMsg + message);
            }
            case 503: {
                throw new ServiceUnavailableException(Messages.MicrosoftTranslatorProvider_503ErrorMsg + message);
            }
            default: {
                throw new TranslationServiceException(Messages.MicrosoftTranslatorProvider_UnknownErrorMsg + message);
            }
        }
    }
}

