/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.events;

import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.ModuleType;
import com._1c.g5.v8.dt.bsl.resource.BslEventsService;
import com._1c.g5.v8.dt.lcore.util.CaseInsensitiveString;
import com._1c.g5.v8.dt.mcore.Event;
import com._1c.g5.v8.dt.metadata.mdclass.CommonModule;
import com._1c.g5.v8.dt.metadata.mdclass.EventSubscription;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.ScheduledJob;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class CommonModuleEventsComputedNameProvider
implements IComputedStringFeatureTranslationProvider {
    private static final String USER_DATA_EVENT_NAME = "eventName";
    private static final String USER_DATA_METHOD_NAME = "methodName";
    private static final String USER_DATA_COMMON_MODULE_NAME = "commonModuleName";
    @Inject
    private BslEventsService bslEventsService;
    @Inject
    private INamedEObjectNameProvider namedEObjectNameProvider;
    private IScopeProvider scopeProvider;

    public boolean isSupported(EObject object) {
        if (!(object instanceof Method)) {
            return false;
        }
        CommonModule module = CommonModuleEventsComputedNameProvider.getCommonModule(object);
        return module != null && module.isServer();
    }

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        if (!stringFeature.equals(McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME)) {
            return false;
        }
        String name = (String)object.eGet(stringFeature.getEFeature());
        if (StringUtils.isNullOrEmpty((String)name)) {
            return false;
        }
        CommonModule commonModule = CommonModuleEventsComputedNameProvider.getCommonModule(object);
        if (commonModule == null) {
            return false;
        }
        Module module = (Module)EcoreUtil2.getContainerOfType((EObject)object, Module.class);
        if (this.isComputedEventSubscriptionHandler(commonModule, module, name)) {
            return true;
        }
        return this.isComputedScheduledJobHandler(commonModule, module, name);
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        if (!stringFeature.equals(McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME)) {
            return null;
        }
        String name = (String)object.eGet(stringFeature.getEFeature());
        if (StringUtils.isNullOrEmpty((String)name)) {
            return null;
        }
        CommonModule commonModule = CommonModuleEventsComputedNameProvider.getCommonModule(object);
        if (commonModule == null) {
            return null;
        }
        Module module = (Module)EcoreUtil2.getContainerOfType((EObject)object, Module.class);
        String translation = this.computeTranslatedEventSubscribtionHandler(commonModule, module, name, translationProvider, language);
        if (StringUtils.isNullOrEmpty((String)translation)) {
            translation = this.computeTranslatedScheduledJobHandler(commonModule, module, name, translationProvider, language);
        }
        return translation;
    }

    private static CommonModule getCommonModule(EObject obj) {
        CommonModule commonModule = null;
        if (obj instanceof CommonModule) {
            commonModule = (CommonModule)obj;
        } else {
            Module module = null;
            module = obj instanceof Module ? (Module)obj : (Module)EcoreUtil2.getContainerOfType((EObject)obj, Module.class);
            if (module != null && module.getModuleType().equals((Object)ModuleType.COMMON_MODULE) && module.getOwner() != null) {
                commonModule = (CommonModule)EcoreUtil2.resolve((EObject)module.getOwner(), (EObject)obj);
            }
        }
        return commonModule;
    }

    private boolean isComputedEventSubscriptionHandler(CommonModule commonModule, Module module, String name) {
        Map eventHandlers = this.bslEventsService.getEventHandlers(module);
        List handlers = (List)eventHandlers.get(new CaseInsensitiveString(name));
        if (handlers == null || handlers.isEmpty()) {
            return false;
        }
        String moduleName = commonModule.getName();
        IScope scope = this.getScopeProvider().getScope((EObject)module, MdClassPackage.Literals.CONFIGURATION__EVENT_SUBSCRIPTIONS);
        for (IEObjectDescription item : scope.getAllElements()) {
            String methodName;
            if (!moduleName.equalsIgnoreCase(item.getUserData(USER_DATA_COMMON_MODULE_NAME)) || !name.equalsIgnoreCase(methodName = Strings.nullToEmpty((String)item.getUserData(USER_DATA_METHOD_NAME)).split("\\.")[2])) continue;
            EObject es = EcoreUtil.resolve((EObject)item.getEObjectOrProxy(), (EObject)module);
            if (es == null || es.eIsProxy()) {
                return false;
            }
            String eventSubscribtionName = ((EventSubscription)es).getName();
            String eventName = item.getUserData(USER_DATA_EVENT_NAME);
            if (StringUtils.isNullOrEmpty((String)eventName)) {
                return false;
            }
            String handlerName = eventSubscribtionName + eventName;
            if (methodName.equalsIgnoreCase(handlerName) || methodName.equalsIgnoreCase(eventName) || methodName.equalsIgnoreCase(eventSubscribtionName)) {
                return true;
            }
            EObject event = (EObject)handlers.get(0);
            if (!(event instanceof Event)) continue;
            eventName = ((Event)event).getName();
            handlerName = eventSubscribtionName + eventName;
            if (methodName.equalsIgnoreCase(handlerName) || methodName.equalsIgnoreCase(eventName)) {
                return true;
            }
            eventName = ((Event)event).getNameRu();
            handlerName = eventSubscribtionName + eventName;
            if (!methodName.equalsIgnoreCase(handlerName) && !methodName.equalsIgnoreCase(eventName)) continue;
            return true;
        }
        return false;
    }

    private boolean isComputedScheduledJobHandler(CommonModule commonModule, Module module, String name) {
        String moduleName = commonModule.getName();
        IScope scope = this.getScopeProvider().getScope((EObject)module, MdClassPackage.Literals.CONFIGURATION__SCHEDULED_JOBS);
        for (IEObjectDescription item : scope.getAllElements()) {
            ScheduledJob sj;
            String methodName = item.getUserData(USER_DATA_METHOD_NAME);
            if (StringUtils.isNullOrEmpty((String)methodName)) {
                return false;
            }
            String[] parts = methodName.split("\\.");
            if (parts.length != 3 || !moduleName.equalsIgnoreCase(parts[1]) || !name.equalsIgnoreCase(parts[2]) || !name.equalsIgnoreCase((sj = (ScheduledJob)EcoreUtil2.resolve((EObject)item.getEObjectOrProxy(), (EObject)module)).getName())) continue;
            return true;
        }
        return false;
    }

    private String computeTranslatedEventSubscribtionHandler(CommonModule commonModule, Module module, String name, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        String moduleName = commonModule.getName();
        IScope scope = this.getScopeProvider().getScope((EObject)module, MdClassPackage.Literals.CONFIGURATION__EVENT_SUBSCRIPTIONS);
        for (IEObjectDescription item : scope.getAllElements()) {
            String methodName;
            if (!moduleName.equalsIgnoreCase(item.getUserData(USER_DATA_COMMON_MODULE_NAME)) || !name.equalsIgnoreCase(methodName = Strings.nullToEmpty((String)item.getUserData(USER_DATA_METHOD_NAME)).split("\\.")[2])) continue;
            EObject es = EcoreUtil.resolve((EObject)item.getEObjectOrProxy(), (EObject)module);
            if (es == null || es.eIsProxy()) {
                return null;
            }
            String eventSubscribtionName = ((EventSubscription)es).getName();
            String eventName = item.getUserData(USER_DATA_EVENT_NAME);
            String handlerName = eventSubscribtionName + eventName;
            if (methodName.equalsIgnoreCase(eventName)) {
                return eventName;
            }
            String translation = null;
            Pair names = this.namedEObjectNameProvider.getTranslatedName(es, translationProvider);
            if (names != null && eventSubscribtionName.equalsIgnoreCase((String)names.getKey())) {
                translation = (String)names.getValue();
            }
            if (methodName.equalsIgnoreCase(eventSubscribtionName)) {
                return translation;
            }
            if (methodName.equalsIgnoreCase(handlerName)) {
                if (!StringUtils.isNotEmpty((String)translation)) continue;
                return translation + eventName;
            }
            Map eventHandlers = this.bslEventsService.getEventHandlers(module);
            List handlers = (List)eventHandlers.get(new CaseInsensitiveString(name));
            if (handlers == null || handlers.isEmpty() || StringUtils.isNullOrEmpty((String)translation)) {
                return null;
            }
            EObject e = (EObject)handlers.get(0);
            if (!(e instanceof Event)) continue;
            Event event = (Event)e;
            eventName = event.getName();
            handlerName = eventSubscribtionName + eventName;
            if (methodName.equalsIgnoreCase(handlerName) || methodName.equalsIgnoreCase(eventName)) {
                if (translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.ENGLISH)) {
                    return translation + event.getName();
                }
                return translation + event.getNameRu();
            }
            eventName = event.getNameRu();
            handlerName = eventSubscribtionName + eventName;
            if (!methodName.equalsIgnoreCase(handlerName) && !methodName.equalsIgnoreCase(eventName)) continue;
            if (translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.ENGLISH)) {
                return translation + event.getName();
            }
            return translation + event.getNameRu();
        }
        return null;
    }

    private String computeTranslatedScheduledJobHandler(CommonModule commonModule, Module module, String name, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        String moduleName = commonModule.getName();
        IScope scope = this.getScopeProvider().getScope((EObject)module, MdClassPackage.Literals.CONFIGURATION__SCHEDULED_JOBS);
        for (IEObjectDescription item : scope.getAllElements()) {
            ScheduledJob sj;
            String methodName = item.getUserData(USER_DATA_METHOD_NAME);
            if (methodName == null) {
                return null;
            }
            String[] parts = methodName.split("\\.");
            if (parts.length != 3 || !moduleName.equalsIgnoreCase(parts[1]) || !name.equalsIgnoreCase(parts[2]) || !name.equalsIgnoreCase((sj = (ScheduledJob)EcoreUtil2.resolve((EObject)item.getEObjectOrProxy(), (EObject)module)).getName())) continue;
            Pair translation = this.namedEObjectNameProvider.getTranslatedName((EObject)sj, translationProvider);
            if (translation != null && name.equalsIgnoreCase((String)translation.getKey())) {
                return (String)translation.getValue();
            }
            return null;
        }
        return null;
    }

    private IScopeProvider getScopeProvider() {
        if (this.scopeProvider == null) {
            IResourceServiceProvider rsp = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.bsl"));
            this.scopeProvider = (IScopeProvider)rsp.get(IScopeProvider.class);
        }
        return this.scopeProvider;
    }
}

