/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.history.ui;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.history.db.IProjectTranslation;
import com.e1c.langtool.history.db.pagination.IPage;
import com.e1c.langtool.history.provider.IHistoryTranslationProvider;
import com.e1c.langtool.history.ui.Messages;
import com.e1c.langtool.history.ui.prefs.PreferenceProvider;
import com.e1c.langtool.ui.common.UiSynchronizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class DetailTranslationDialog
extends Dialog {
    private TableViewer tableViewer;
    private Button loadPageButton;
    private String queryText;

    public DetailTranslationDialog(Shell parent) {
        super(parent);
        this.setShellStyle(112);
        this.setBlockOnOpen(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        this.tableViewer = new TableViewer(composite, 2818);
        this.createColumns();
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.loadPageButton = new Button(composite, 0);
        this.loadPageButton.setText(Messages.DetailTranslationDialog_LoadNewPageButton);
        this.loadPageButton.setLayoutData((Object)new GridData(4, 3, true, false));
        this.loadPageButton.setVisible(false);
        return composite;
    }

    public int open(IHistoryTranslationProvider.ITranslationResult result, String query) {
        Shell shell = this.getShell();
        shell.setSize(1000, 350);
        String title = Arrays.stream(query.trim().split("\n")).map(String::trim).collect(Collectors.joining(" "));
        shell.setText(Messages.DetailTranslationDialog_Title + " \"" + title + "\"");
        this.queryText = query;
        UiSynchronizer.defaultAsyncExec(() -> this.showTranslations(result));
        return this.open();
    }

    private void showTranslations(IHistoryTranslationProvider.ITranslationResult result) {
        int pageSize = PreferenceProvider.getDetailTranslationsPageSize();
        Iterator iterator = result.iterator(pageSize);
        if (iterator.hasNext()) {
            ((IPage)iterator.next()).forEach(arg_0 -> ((TableViewer)this.tableViewer).add(arg_0));
        }
        if (iterator.hasNext()) {
            this.loadPageButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> UiSynchronizer.asyncExec((Widget)this.loadPageButton, () -> this.loadPage(iterator))));
            this.loadPageButton.setVisible(true);
        } else {
            this.loadPageButton.setVisible(false);
        }
    }

    private void loadPage(Iterator<IPage<IProjectTranslation>> iterator) {
        iterator.next().forEach(arg_0 -> ((TableViewer)this.tableViewer).add(arg_0));
        if (!iterator.hasNext()) {
            this.loadPageButton.setVisible(false);
        }
    }

    private StyleRange getStyleRange(String sourceString, String subString, int color) {
        int startIndex = sourceString.indexOf(subString);
        return new StyleRange(startIndex, subString.length(), null, Display.getCurrent().getSystemColor(color));
    }

    private void createColumns() {
        TableViewerColumn transCol = this.createTableViewerColumn(Messages.DetailTranslationDialog_TranslationColumnName, 120);
        transCol.setLabelProvider((CellLabelProvider)this.createColumnProvider(IProjectTranslation::getTranslation));
        TableViewerColumn sourceValueCol = this.createTableViewerColumn(Messages.DetailTranslationDialog_SourceValueColumnName, 120);
        sourceValueCol.setLabelProvider((CellLabelProvider)this.createColumnProvider(IProjectTranslation::getValue));
        sourceValueCol.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                IProjectTranslation trans = (IProjectTranslation)cell.getElement();
                cell.setText(trans.getValue());
                String lowerValue = trans.getValue().toLowerCase();
                String lowerQuery = DetailTranslationDialog.this.queryText.toLowerCase();
                ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
                if (lowerValue.equals(lowerQuery)) {
                    styleRanges.add(DetailTranslationDialog.this.getStyleRange(lowerValue, lowerQuery, 5));
                } else {
                    String[] queryParts;
                    String[] stringArray = queryParts = StringUtils.nameToText((String)DetailTranslationDialog.this.queryText).toLowerCase().split(" ");
                    int n = queryParts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String part = stringArray[n2];
                        styleRanges.add(DetailTranslationDialog.this.getStyleRange(lowerValue, part, 7));
                        ++n2;
                    }
                }
                StyleRange[] resultStyleRanges = styleRanges.toArray(new StyleRange[styleRanges.size()]);
                cell.setStyleRanges(resultStyleRanges);
                super.update(cell);
            }
        });
        TableViewerColumn resourceIdCol = this.createTableViewerColumn(Messages.DetailTranslationDialog_ResourceIdColumnName, 220);
        resourceIdCol.setLabelProvider((CellLabelProvider)this.createColumnProvider(IProjectTranslation::getResourceId));
        TableViewerColumn featureKeyCol = this.createTableViewerColumn(Messages.DetailTranslationDialog_FeatureKeyColumnName, 220);
        featureKeyCol.setLabelProvider((CellLabelProvider)this.createColumnProvider(IProjectTranslation::getFeatureKey));
        TableViewerColumn featureNameCol = this.createTableViewerColumn(Messages.DetailTranslationDialog_FeatureNameColumnName, 110);
        featureNameCol.setLabelProvider((CellLabelProvider)this.createColumnProvider(IProjectTranslation::getFeatureName));
        TableViewerColumn contextCol = this.createTableViewerColumn(Messages.DetailTranslationDialog_ContextColumnName, 80);
        contextCol.setLabelProvider((CellLabelProvider)this.createColumnProvider(trans -> trans.getContext().toString()));
        TableViewerColumn langaugeCol = this.createTableViewerColumn(Messages.DetailTranslationDialog_LanguageColumnName, 50);
        langaugeCol.setLabelProvider((CellLabelProvider)this.createColumnProvider(IProjectTranslation::getLanguage));
    }

    private ColumnLabelProvider createColumnProvider(final Function<IProjectTranslation, String> adapter) {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                IProjectTranslation trans = (IProjectTranslation)element;
                return (String)adapter.apply(trans);
            }
        };
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }
}

